/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import si.nevensrok.common.network.streams.DataBuffer;

public class StreamSplitter {
    private static final int DATA_FULL = 0;
    private static final int DATA_INFO = 1;
    private static final int DATA_CONTENT = 2;
    private OutputStream outputStream;
    private InputStream inputStream;
    private int maxMessageSize;
    private int chunkSize;
    private final Object outputStreamMonitor = new Object();
    private final Object inputStreamMonitor = new Object();
    private int indexCounter = Integer.MIN_VALUE;
    private final Object indexMonitor = new Object();
    private long lastActivityAt = Long.MIN_VALUE;
    private final Map<Integer, DataBuffer> dataMap = new HashMap<Integer, DataBuffer>();

    public StreamSplitter(OutputStream outputStream, InputStream inputStream, int maxMessageSize, int chunkSize) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.maxMessageSize = maxMessageSize;
        this.chunkSize = chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIndex() {
        Object object = this.indexMonitor;
        synchronized (object) {
            return this.indexCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(byte[] data) throws IOException {
        if (data.length <= this.chunkSize) {
            Object object = this.outputStreamMonitor;
            synchronized (object) {
                this.writeByte(0);
                this.writeInt(data.length);
                this.outputStream.write(data);
                this.outputStream.flush();
            }
            this.lastActivityAt = System.currentTimeMillis();
        } else {
            int bytesToWrite;
            int dataId = this.getNextIndex();
            Object object = this.outputStreamMonitor;
            synchronized (object) {
                this.writeByte(1);
                this.writeInt(dataId);
                this.writeInt(data.length);
            }
            this.lastActivityAt = System.currentTimeMillis();
            for (int bytesWritten = 0; bytesWritten < data.length; bytesWritten += bytesToWrite) {
                bytesToWrite = Math.min(this.chunkSize, data.length - bytesWritten);
                Object object2 = this.outputStreamMonitor;
                synchronized (object2) {
                    this.writeByte(2);
                    this.writeInt(dataId);
                    this.writeInt(bytesToWrite);
                    this.outputStream.write(data, bytesWritten, bytesToWrite);
                }
                this.lastActivityAt = System.currentTimeMillis();
            }
            Object object3 = this.outputStreamMonitor;
            synchronized (object3) {
                this.outputStream.flush();
            }
        }
    }

    public byte[] readData() throws IOException {
        Object object = this.inputStreamMonitor;
        synchronized (object) {
            int c;
            block13: {
                DataBuffer dataBuffer;
                int dataId;
                while (true) {
                    int n;
                    if ((c = this.readByte()) == 0) {
                        int n2;
                        int dataLength = this.readInt();
                        byte[] data = new byte[dataLength];
                        for (int dataRead = 0; dataRead < dataLength; dataRead += n2) {
                            n2 = this.inputStream.read(data, dataRead, dataLength - dataRead);
                            if (n2 < 0) {
                                throw new IOException("End of stream reached");
                            }
                            this.lastActivityAt = System.currentTimeMillis();
                        }
                        return data;
                    }
                    if (c == 1) {
                        dataId = this.readInt();
                        int dataLength = this.readInt();
                        if (dataLength > this.maxMessageSize) {
                            throw new IOException("Received data length " + dataLength + " is too big");
                        }
                        this.dataMap.put(dataId, new DataBuffer(dataLength));
                        this.lastActivityAt = System.currentTimeMillis();
                        continue;
                    }
                    if (c != 2) break block13;
                    dataId = this.readInt();
                    int chunkLength = this.readInt();
                    if (chunkLength > this.maxMessageSize) {
                        throw new IOException("Received chunk length " + chunkLength + " is too big");
                    }
                    dataBuffer = this.dataMap.get(dataId);
                    this.lastActivityAt = System.currentTimeMillis();
                    if (dataBuffer == null) {
                        throw new IOException("Invalid data id received '" + dataId + "'");
                    }
                    byte[] data = new byte[chunkLength];
                    for (int dataRead = 0; dataRead < chunkLength; dataRead += n) {
                        n = this.inputStream.read(data, dataRead, chunkLength - dataRead);
                        if (n < 0) {
                            throw new IOException("End of stream reached");
                        }
                        this.lastActivityAt = System.currentTimeMillis();
                    }
                    dataBuffer.addData(data);
                    if (dataBuffer.isFull()) break;
                }
                this.dataMap.remove(dataId);
                return dataBuffer.getData();
            }
            throw new IOException("Unexpected data received '" + c + "'");
        }
    }

    private void writeByte(int value) throws IOException {
        this.outputStream.write(value);
    }

    private int readByte() throws IOException {
        int n = this.inputStream.read();
        if (n < 0) {
            throw new IOException("End of stream reached");
        }
        return n;
    }

    private void writeInt(int value) throws IOException {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.outputStream.write(bytes);
    }

    private int readInt() throws IOException {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n = this.inputStream.read();
            if (n < 0) {
                throw new IOException("End of stream reached");
            }
            bytes[i] = (byte)n;
        }
        int value = 0;
        value += bytes[0] & 0xFF;
        value += bytes[1] << 8 & 0xFF00;
        value += bytes[2] << 16 & 0xFF0000;
        return value += bytes[3] << 24 & 0xFF000000;
    }

    public long getLastActivityAt() {
        return this.lastActivityAt;
    }
}

