/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.lock;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.lock.LockItem;
import si.nevensrok.common.lock.LockService;
import si.nevensrok.common.threads.PeriodicJobStatus;
import si.nevensrok.common.threads.ThreadUtil;

public abstract class AbstractExternalLockService
implements LockService,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractExternalLockService.class);
    private long checkInPeriod = TimeUnit.SECONDS.toMillis(3L);
    private long lockExpireTime = TimeUnit.HOURS.toMillis(25L);
    private long lockCleanupPeriod = TimeUnit.HOURS.toMillis(6L);
    private String memberId;
    private PeriodicJobStatus checkInJob = null;
    private PeriodicJobStatus cleanJob = null;
    private Map<String, LockItem> locks = new HashMap<String, LockItem>();

    public AbstractExternalLockService() {
        this.memberId = UUID.randomUUID().toString();
    }

    protected String getMemberId() {
        return this.memberId;
    }

    public void setCheckInPeriod(long checkInPeriod) {
        this.checkInPeriod = checkInPeriod;
    }

    public void setLockExpireTime(long lockExpireTime) {
        this.lockExpireTime = lockExpireTime;
    }

    public void setLockCleanupPeriod(long lockCleanupPeriod) {
        this.lockCleanupPeriod = lockCleanupPeriod;
    }

    public void afterPropertiesSet() throws Exception {
        ThreadUtil.runInBackground(new Runnable(){

            @Override
            public void run() {
                while (!AbstractExternalLockService.this.announceMember()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, true);
        this.checkInJob = ThreadUtil.runPeriodicJob(this.checkInPeriod, new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractExternalLockService.this.checkInMember();
                }
                catch (Throwable e) {
                    log.error("Error checking in", e);
                }
            }
        }, true);
        this.cleanJob = ThreadUtil.runPeriodicJob(this.lockCleanupPeriod, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long timeLimit = System.currentTimeMillis() - AbstractExternalLockService.this.lockExpireTime;
                    Map map = AbstractExternalLockService.this.locks;
                    synchronized (map) {
                        for (String name : new LinkedList(AbstractExternalLockService.this.locks.keySet())) {
                            LockItem lockItem = (LockItem)AbstractExternalLockService.this.locks.get(name);
                            if (lockItem.getLastUsageTime() >= timeLimit) continue;
                            AbstractExternalLockService.this.locks.remove(name);
                        }
                    }
                }
                catch (Throwable e) {
                    log.error("Error cleaning up expired locks", e);
                }
                try {
                    AbstractExternalLockService.this.cleanupExpiredData();
                }
                catch (Throwable e) {
                    log.error("Error cleaning up expired data", e);
                }
            }
        }, true);
    }

    public void destroy() throws Exception {
        if (this.checkInJob != null) {
            this.checkInJob.stop();
        }
        if (this.cleanJob != null) {
            this.cleanJob.stop();
        }
        this.departMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getLockByName(String name) {
        LockItem lockItem;
        Map<String, LockItem> map = this.locks;
        synchronized (map) {
            lockItem = this.locks.get(name);
            if (lockItem == null) {
                lockItem = new LockItem(this.generateLock(name));
                this.locks.put(name, lockItem);
            }
            lockItem.touch();
        }
        return lockItem.getLock();
    }

    protected abstract boolean announceMember();

    protected abstract void departMember();

    protected abstract void checkInMember();

    protected abstract void cleanupExpiredData();

    protected abstract Lock generateLock(String var1);
}

