/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataexport;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import si.nevensrok.common.dataexport.AbstractFileWriter;

public class OdsFileWriter
extends AbstractFileWriter {
    private static final String emptyFilePath = "/si/nevensrok/common/dataexport/empty.ods";
    private ZipOutputStream zipOutputStream;
    private List<String[]> lines = new LinkedList<String[]>();

    @Override
    public void init(OutputStream outputStream) throws Exception {
        this.zipOutputStream = new ZipOutputStream(outputStream);
    }

    @Override
    public void close() throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(new ClassPathResource(emptyFilePath).getInputStream());
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            ZipEntry outZipEntry = new ZipEntry(zipEntry.getName());
            this.zipOutputStream.putNextEntry(outZipEntry);
            if (zipEntry.getName().equalsIgnoreCase("content.xml")) {
                byte[] data = OdsFileWriter.readData(zipInputStream);
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document document = docBuilder.parse(new ByteArrayInputStream(data));
                Element rootElement = document.getDocumentElement();
                Node bodyNode = OdsFileWriter.getSubNodeByName(rootElement, "office:body");
                Node spreadsheetNode = OdsFileWriter.getSubNodeByName(bodyNode, "office:spreadsheet");
                Node tableNode = OdsFileWriter.getSubNodeByName(spreadsheetNode, "table:table");
                List<Node> tableRowNodes = OdsFileWriter.getSubNodesByName(tableNode, "table:table-row");
                for (Node node : tableRowNodes) {
                    tableNode.removeChild(node);
                }
                for (String[] line : this.lines) {
                    Element rowElement = document.createElement("table:table-row");
                    rowElement.setAttribute("style-name", "ro1");
                    tableNode.appendChild(rowElement);
                    for (String text : line) {
                        Element cellElement = document.createElement("table:table-cell");
                        cellElement.setAttribute("style-name", "ce1");
                        cellElement.setAttribute("value-type", "string");
                        rowElement.appendChild(cellElement);
                        Element textElement = document.createElement("text:p");
                        textElement.setTextContent(text);
                        cellElement.appendChild(textElement);
                    }
                }
                OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", false);
                XMLSerializer serializer = new XMLSerializer(this.zipOutputStream, outputFormat);
                serializer.asDOMSerializer();
                serializer.serialize(document.getDocumentElement());
            } else {
                int n = zipInputStream.read();
                while (n >= 0) {
                    this.zipOutputStream.write(n);
                    n = zipInputStream.read();
                }
            }
            this.zipOutputStream.closeEntry();
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        this.zipOutputStream.close();
    }

    @Override
    public void writeLine(String[] line) throws Exception {
        this.lines.add(line);
    }

    private static Node getSubNodeByName(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!name.equals(subNode.getNodeName())) continue;
            return subNode;
        }
        return null;
    }

    private static Node getSubNodeByName(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!name.equals(subNode.getNodeName())) continue;
            return subNode;
        }
        return null;
    }

    private static List<Node> getSubNodesByName(Node node, String name) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!name.equals(subNode.getNodeName())) continue;
            subNodes.add(subNode);
        }
        return subNodes;
    }

    private static byte[] readData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int n = inputStream.read();
        while (n >= 0) {
            buffer.write(n);
            n = inputStream.read();
        }
        return buffer.toByteArray();
    }
}

