/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageTransformTool {
    private Image image;
    private boolean isFullyLoaded = false;

    public ImageTransformTool(Image image) {
        this.image = image;
    }

    private synchronized void setFullyLoaded() {
        this.isFullyLoaded = true;
        this.notifyAll();
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
        Graphics2D g = bufferedImage.createGraphics();
        final ImageTransformTool imageTransformTool = this;
        this.isFullyLoaded = g.drawImage(this.image, null, new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (infoflags == 32) {
                    imageTransformTool.setFullyLoaded();
                }
                return infoflags != 32;
            }
        });
        while (!this.isFullyLoaded) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        return bufferedImage;
    }

    public static BufferedImage transformToBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ImageTransformTool imageTransformTool = new ImageTransformTool(image);
        return imageTransformTool.getBufferedImage();
    }
}

