/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.vertical;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.DuoPointsDocument;
import si.nevensrok.jtekma.tabla.gui.duo.DuoTextFieldKeyListener;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class VerticalDuoPointsPanel
extends JPanel
implements InitializingBean {
    private static final long serialVersionUID = -8169294353628769118L;
    private Font labelFont = new Font("Serif", 1, 34);
    private Font textFieldFont = new Font("Serif", 0, 34);
    private JLabel[] roundLabels = new JLabel[5];
    private JLabel[] summaryLabels = new JLabel[5];
    private JTextField[][] pointFields = new JTextField[5][5];
    private DuoPoints duoPoints;
    private TablaManager tablaManager;
    private WindowKeyListener windowKeyListener;
    private DuoTextFieldKeyListener duoTextFieldKeyListener;
    private CompetitorType competitorType;

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPoints = duoPoints;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        this.windowKeyListener = windowKeyListener;
    }

    public void setDuoTextFieldKeyListener(DuoTextFieldKeyListener duoTextFieldKeyListener) {
        this.duoTextFieldKeyListener = duoTextFieldKeyListener;
    }

    public void setCompetitorType(CompetitorType competitorType) {
        this.competitorType = competitorType;
    }

    public VerticalDuoPointsPanel() {
        this.setLayout(new GridLayout(5, 7));
        for (int round = 1; round <= 5; ++round) {
            this.roundLabels[round - 1] = new JLabel(String.valueOf(round < 5 ? Integer.valueOf(round) : "E"));
            this.roundLabels[round - 1].setFont(this.labelFont);
            this.add(this.roundLabels[round - 1]);
            for (int judge = 1; judge <= 5; ++judge) {
                this.pointFields[round - 1][judge - 1] = new JTextField();
                this.add(this.pointFields[round - 1][judge - 1]);
                this.pointFields[round - 1][judge - 1].setFont(this.textFieldFont);
            }
            this.summaryLabels[round - 1] = new JLabel("0");
            this.summaryLabels[round - 1].setFont(this.labelFont);
            this.add(this.summaryLabels[round - 1]);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (int round = 0; round < 5; ++round) {
            for (int judge = 0; judge < 5; ++judge) {
                this.pointFields[round][judge].addKeyListener(this.windowKeyListener);
                this.pointFields[round][judge].addKeyListener(this.duoTextFieldKeyListener);
                this.pointFields[round][judge].setDocument(new DuoPointsDocument(this.competitorType, round + 1, judge + 1, this.duoPoints, this.tablaManager));
            }
        }
    }

    public void redrawElements() {
        final VerticalDuoPointsPanel panel = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (VerticalDuoPointsPanel.this.competitorType == CompetitorType.COMPETITOR1) {
                    panel.setBackground(Constants.competitor1bgColor);
                } else {
                    panel.setBackground(Constants.competitor2bgColor);
                }
                for (int round = 1; round <= 5; ++round) {
                    if (VerticalDuoPointsPanel.this.competitorType == CompetitorType.COMPETITOR1) {
                        VerticalDuoPointsPanel.this.roundLabels[round - 1].setForeground(Constants.competitor1fgColor);
                    } else if (VerticalDuoPointsPanel.this.competitorType == CompetitorType.COMPETITOR2) {
                        VerticalDuoPointsPanel.this.roundLabels[round - 1].setForeground(Constants.competitor2fgColor);
                    }
                    VerticalDuoPointsPanel.this.roundLabels[round - 1].setHorizontalAlignment(0);
                    FontSizeUtil.refitFontSize(VerticalDuoPointsPanel.this.labelFont, VerticalDuoPointsPanel.this.roundLabels[round - 1]);
                    for (int judge = 1; judge <= 5; ++judge) {
                        VerticalDuoPointsPanel.this.pointFields[round - 1][judge - 1].setHorizontalAlignment(0);
                        FontSizeUtil.refitFontSize(VerticalDuoPointsPanel.this.textFieldFont, VerticalDuoPointsPanel.this.pointFields[round - 1][judge - 1]);
                    }
                    if (VerticalDuoPointsPanel.this.competitorType == CompetitorType.COMPETITOR1) {
                        VerticalDuoPointsPanel.this.summaryLabels[round - 1].setForeground(Constants.competitor1fgColor);
                    } else if (VerticalDuoPointsPanel.this.competitorType == CompetitorType.COMPETITOR2) {
                        VerticalDuoPointsPanel.this.summaryLabels[round - 1].setForeground(Constants.competitor2fgColor);
                    }
                    VerticalDuoPointsPanel.this.summaryLabels[round - 1].setHorizontalAlignment(0);
                    FontSizeUtil.refitFontSize(VerticalDuoPointsPanel.this.labelFont, VerticalDuoPointsPanel.this.summaryLabels[round - 1]);
                }
            }
        });
    }

    public void resetPoints() {
        for (int round = 1; round <= 5; ++round) {
            for (int judge = 1; judge <= 5; ++judge) {
                float p = 0.0f;
                if (this.competitorType == CompetitorType.COMPETITOR1) {
                    p = this.duoPoints.getPoints1(round, judge);
                } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                    p = this.duoPoints.getPoints2(round, judge);
                }
                this.pointFields[round - 1][judge - 1].setText(String.valueOf(p));
                FontSizeUtil.refitFontSize(this.textFieldFont, this.pointFields[round - 1][judge - 1]);
            }
        }
        this.recalculateRoundPoints();
    }

    public void recalculateRoundPoints() {
        for (int round = 1; round <= 5; ++round) {
            float sum = 0.0f;
            float max = 0.0f;
            float min = Float.MAX_VALUE;
            for (int judge = 1; judge <= 5; ++judge) {
                float p = 0.0f;
                if (this.competitorType == CompetitorType.COMPETITOR1) {
                    p = this.duoPoints.getPoints1(round, judge);
                } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                    p = this.duoPoints.getPoints2(round, judge);
                }
                sum += p;
                if (p > max) {
                    max = p;
                }
                if (!(p < min)) continue;
                min = p;
            }
            sum -= max + min;
            sum = (float)Math.round(sum * 10.0f) / 10.0f;
            this.summaryLabels[round - 1].setText(String.valueOf(sum));
            FontSizeUtil.refitFontSize(this.labelFont, this.summaryLabels[round - 1]);
        }
    }

    public void selectField(int index) {
        int n = 0;
        for (int round = 0; round < 5; ++round) {
            for (int judge = 0; judge < 5; ++judge) {
                if (++n != index) continue;
                this.pointFields[round][judge].requestFocus();
                this.pointFields[round][judge].setSelectionStart(0);
                this.pointFields[round][judge].setSelectionEnd(this.pointFields[round][judge].getText().length());
                return;
            }
        }
    }

    public int getSeletedField() {
        int n = 0;
        for (int round = 0; round < 5; ++round) {
            for (int judge = 0; judge < 5; ++judge) {
                ++n;
                if (!this.pointFields[round][judge].hasFocus()) continue;
                return n;
            }
        }
        return 0;
    }
}

