/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeGenerator;
import si.nevensrok.common.qrcode.QRCodeParser;
import si.nevensrok.common.qrcode.QRCodeType;
import si.nevensrok.common.qrcode.QRTypeChecker;
import si.nevensrok.common.qrcode.codes.QRContactCode;
import si.nevensrok.common.qrcode.codes.QREmailCode;
import si.nevensrok.common.qrcode.codes.QRGAuthCode;
import si.nevensrok.common.qrcode.codes.QRGpsCode;
import si.nevensrok.common.qrcode.codes.QRPhoneCode;
import si.nevensrok.common.qrcode.codes.QRSmsCode;
import si.nevensrok.common.qrcode.codes.QRTextCode;
import si.nevensrok.common.qrcode.codes.QRUrlCode;
import si.nevensrok.common.qrcode.codes.QRWifiCode;

public class ZxingQRCodeTool
implements QRCodeGenerator,
QRCodeParser,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ZxingQRCodeTool.class);
    private Map<QRCodeType, Class<?>> qrCodeClasses = null;
    private int imageWidth = 200;
    private int imageHeight = 200;

    public void afterPropertiesSet() throws Exception {
        if (this.qrCodeClasses == null) {
            this.qrCodeClasses = new HashMap();
            this.qrCodeClasses.put(QRCodeType.CONTACT, QRContactCode.class);
            this.qrCodeClasses.put(QRCodeType.EMAIL, QREmailCode.class);
            this.qrCodeClasses.put(QRCodeType.GPS, QRGpsCode.class);
            this.qrCodeClasses.put(QRCodeType.PHONE, QRPhoneCode.class);
            this.qrCodeClasses.put(QRCodeType.SMS, QRSmsCode.class);
            this.qrCodeClasses.put(QRCodeType.TEXT, QRTextCode.class);
            this.qrCodeClasses.put(QRCodeType.URL, QRUrlCode.class);
            this.qrCodeClasses.put(QRCodeType.WIFI, QRWifiCode.class);
            this.qrCodeClasses.put(QRCodeType.GAUTH, QRGAuthCode.class);
        }
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Map<QRCodeType, Class<?>> getQrCodeClasses() {
        return this.qrCodeClasses;
    }

    public void setQrCodeClasses(Map<QRCodeType, Class<?>> qrCodeClasses) {
        this.qrCodeClasses = qrCodeClasses;
    }

    @Override
    public BufferedImage generateQRCode(QRCode qrCode) {
        return this.generateQRCode(qrCode, this.imageWidth, this.imageHeight);
    }

    @Override
    public BufferedImage generateQRCode(QRCode qrCode, int width, int height) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Generating QR code {}", (Object)qrCode);
            }
            String text = qrCode.getCodeText();
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix matrix = writer.encode(text, BarcodeFormat.QR_CODE, width, height);
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (matrix.get(x, y)) {
                        image.setRGB(x, y, 0);
                        continue;
                    }
                    image.setRGB(x, y, 0xFFFFFF);
                }
            }
            return image;
        }
        catch (Exception e) {
            log.error("Error while generating QR code", (Throwable)e);
            return null;
        }
    }

    @Override
    public QRCode parseQRCode(BufferedImage image) throws QRCodeException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing QR code form image");
            }
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            Result result = new MultiFormatReader().decode(bitmap);
            String text = result.getText();
            if (log.isDebugEnabled()) {
                log.debug("QR code text: [{}]", (Object)text);
            }
            QRCodeType qrType = QRTypeChecker.getQRType(text);
            if (log.isDebugEnabled()) {
                log.debug("QR code type: {}", (Object)qrType);
            }
            QRCode qrCode = null;
            Class<Object> qrClass = this.qrCodeClasses.get((Object)qrType);
            if (log.isDebugEnabled()) {
                log.debug("QR code class: {}", qrClass);
            }
            if (qrClass == null) {
                if (log.isDebugEnabled()) {
                    log.debug("QR code class is null using {}", QRTextCode.class);
                }
                qrClass = QRTextCode.class;
            }
            qrCode = (QRCode)qrClass.newInstance();
            qrCode.parseCode(text);
            return qrCode;
        }
        catch (Exception e) {
            log.error("Error while parsing QR code", (Throwable)e);
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }
}

