/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.barcode.barcode4j;

import java.awt.image.BufferedImage;
import org.krysalis.barcode4j.impl.codabar.CodabarBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.impl.upcean.UPCEBean;
import org.krysalis.barcode4j.output.bitmap.BitmapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.barcode.Barcode;
import si.nevensrok.common.barcode.BarcodeGenerator;

public class SimpleBarcodeGenerator
implements BarcodeGenerator,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SimpleBarcodeGenerator.class);
    private BarcodeType barcodeType = BarcodeType.INT2OF5;
    private int resolution = 300;
    private org.krysalis.barcode4j.BarcodeGenerator barcodeGenerator;

    public BarcodeType getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(BarcodeType barcodeType) {
        this.barcodeType = barcodeType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void afterPropertiesSet() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Initializing bar code genertor for type: {}", (Object)this.barcodeType);
        }
        if (this.barcodeType == null) {
            log.error("Barcode type is not set");
        } else if (this.barcodeType == BarcodeType.INT2OF5) {
            this.barcodeGenerator = new Interleaved2Of5Bean();
        } else if (this.barcodeType == BarcodeType.ITF14) {
            this.barcodeGenerator = new ITF14Bean();
        } else if (this.barcodeType == BarcodeType.CODE39) {
            this.barcodeGenerator = new Code39Bean();
        } else if (this.barcodeType == BarcodeType.CODE128) {
            this.barcodeGenerator = new Code128Bean();
        } else if (this.barcodeType == BarcodeType.CODABAR) {
            this.barcodeGenerator = new CodabarBean();
        } else if (this.barcodeType == BarcodeType.UPCA) {
            this.barcodeGenerator = new UPCABean();
        } else if (this.barcodeType == BarcodeType.UPCE) {
            this.barcodeGenerator = new UPCEBean();
        } else if (this.barcodeType == BarcodeType.EAN13) {
            this.barcodeGenerator = new EAN13Bean();
        } else if (this.barcodeType == BarcodeType.EAN8) {
            this.barcodeGenerator = new EAN8Bean();
        }
    }

    @Override
    public BufferedImage generateBarcode(Barcode barcode) {
        BufferedImage image = BitmapBuilder.getImage((org.krysalis.barcode4j.BarcodeGenerator)this.barcodeGenerator, (String)barcode.getCode(), (int)this.resolution);
        return image;
    }

    public static enum BarcodeType {
        INT2OF5,
        ITF14,
        CODE39,
        CODE128,
        CODABAR,
        UPCA,
        UPCE,
        EAN13,
        EAN8;

    }
}

