/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MemberInfo
implements DataSerializable {
    private Address address;
    private String uuid;
    private boolean liteMember;
    private Map<String, Object> attributes;

    public MemberInfo() {
    }

    public MemberInfo(Address address) {
        this.address = address;
    }

    public MemberInfo(Address address, String uuid, Map<String, Object> attributes) {
        this(address, uuid, attributes, false);
    }

    public MemberInfo(Address address, String uuid, Map<String, Object> attributes, boolean liteMember) {
        this.address = address;
        this.uuid = uuid;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : new HashMap<String, Object>(attributes);
        this.liteMember = liteMember;
    }

    public MemberInfo(MemberImpl member) {
        this(member.getAddress(), member.getUuid(), member.getAttributes(), member.isLiteMember());
    }

    public Address getAddress() {
        return this.address;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        if (in.readBoolean()) {
            this.uuid = in.readUTF();
        }
        this.liteMember = in.readBoolean();
        int size = in.readInt();
        if (size > 0) {
            this.attributes = new HashMap<String, Object>();
        }
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = in.readObject();
            this.attributes.put(key, value);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        boolean hasUuid = this.uuid != null;
        out.writeBoolean(hasUuid);
        if (hasUuid) {
            out.writeUTF(this.uuid);
        }
        out.writeBoolean(this.liteMember);
        out.writeInt(this.attributes == null ? 0 : this.attributes.size());
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public String toString() {
        return "MemberInfo{address=" + this.address + ", uuid=" + this.uuid + ", liteMember=" + this.liteMember + '}';
    }
}

