/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static Document newDocument() throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        return document;
    }

    public static Document readXmlDocument(InputStream inputStream) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.parse(inputStream);
        return document;
    }

    public static Document readXmlDocument(byte[] data) throws Exception {
        return XmlUtil.readXmlDocument(new ByteArrayInputStream(data));
    }

    public static Document readXmlDocument(String string) throws Exception {
        return XmlUtil.readXmlDocument(string.getBytes(Charset.forName("UTF8")));
    }

    public static void writeXmlDocumentToOutputString(Document document, OutputStream outputStream) throws Exception {
        OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", false);
        XMLSerializer serializer = new XMLSerializer(outputStream, outputFormat);
        serializer.asDOMSerializer();
        serializer.serialize(document.getDocumentElement());
    }

    public static byte[] writeXmlDocument(Document document) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        XmlUtil.writeXmlDocumentToOutputString(document, buffer);
        return buffer.toByteArray();
    }

    public static String writeXmlDocumentAsString(Document document) throws Exception {
        byte[] data = XmlUtil.writeXmlDocument(document);
        return new String(data, Charset.forName("UTF8"));
    }

    public static Node getFirstChildNode(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase(name)) continue;
            return subNode;
        }
        return null;
    }

    public static List<Node> getChildNodes(Element element, String name) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase(name)) continue;
            subNodes.add(subNode);
        }
        return subNodes;
    }

    public static List<Node> getChildNodes(Element element) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            subNodes.add(subNode);
        }
        return subNodes;
    }

    public static Node getFirstChildNode(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase(name)) continue;
            return subNode;
        }
        return null;
    }

    public static List<Node> getChildNodes(Node node, String name) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase(name)) continue;
            subNodes.add(subNode);
        }
        return subNodes;
    }

    public static List<Node> getChildNodes(Node node) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            subNodes.add(subNode);
        }
        return subNodes;
    }

    public static Node getFirstChildNode(Node node, Map<String, String> attributes) {
        List<Node> nodes = XmlUtil.getChildNodes(node, attributes);
        if (!nodes.isEmpty()) {
            return nodes.get(0);
        }
        return null;
    }

    public static List<Node> getChildNodes(Node node, Map<String, String> attributes) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            boolean add = true;
            Map<String, String> subNodeAttributes = XmlUtil.getAttributes(subNode);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getValue().equals(subNodeAttributes.get(entry.getKey()))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            subNodes.add(subNode);
        }
        return subNodes;
    }

    public static Node getFirstChildNode(Node node, String name, Map<String, String> attributes) {
        List<Node> nodes = XmlUtil.getChildNodes(node, name, attributes);
        if (!nodes.isEmpty()) {
            return nodes.get(0);
        }
        return null;
    }

    public static List<Node> getChildNodes(Node node, String name, Map<String, String> attributes) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase(name)) continue;
            boolean add = true;
            Map<String, String> subNodeAttributes = XmlUtil.getAttributes(subNode);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getValue().equals(subNodeAttributes.get(entry.getKey()))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            subNodes.add(subNode);
        }
        return subNodes;
    }

    public static String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attributeNode = attributes.item(i);
                if (!attributeNode.getNodeName().equalsIgnoreCase(attributeName)) continue;
                return attributeNode.getTextContent();
            }
        }
        return null;
    }

    public static Map<String, String> getAttributes(Node node) {
        LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attributeNode = attributes.item(i);
                attributesMap.put(attributeNode.getNodeName(), attributeNode.getTextContent());
            }
        }
        return attributesMap;
    }
}

