/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.tcp.ConnectionEstablishedHandler;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;

public class TcpNetworkServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TcpNetworkServer.class);
    private Integer port;
    private ConnectionEstablishedHandler connectionEstablishedHandler = null;
    private boolean active = false;
    private ServerSocket serverSocket = null;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public ConnectionEstablishedHandler getConnectionEstablishedHandler() {
        return this.connectionEstablishedHandler;
    }

    public void setConnectionEstablishedHandler(ConnectionEstablishedHandler connectionEstablishedHandler) {
        this.connectionEstablishedHandler = connectionEstablishedHandler;
    }

    protected ServerSocket openSocket() throws Exception {
        return new ServerSocket(this.port);
    }

    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        return new TcpNetworkConnection(socket);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        log.debug("Starting TCP network server on port {}", (Object)this.port);
        this.active = true;
        this.serverSocket = this.openSocket();
        Thread connectionThread = new Thread("Server connection thread for port " + this.port){

            @Override
            public void run() {
                while (TcpNetworkServer.this.active) {
                    try {
                        Socket socket = TcpNetworkServer.this.serverSocket.accept();
                        TcpNetworkConnection tcpNetworkConnection = TcpNetworkServer.this.openTcpNetworkConnection(socket);
                        tcpNetworkConnection.open();
                        if (TcpNetworkServer.this.connectionEstablishedHandler == null) continue;
                        TcpNetworkServer.this.connectionEstablishedHandler.connectionAccepted(tcpNetworkConnection);
                    }
                    catch (Exception e) {
                        log.trace("Error accepting connection", (Throwable)e);
                    }
                }
            }
        };
        connectionThread.setDaemon(true);
        connectionThread.start();
    }

    public void destroy() throws Exception {
        this.active = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSocket = null;
    }
}

