/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.tcp;

import java.net.URI;
import java.util.LinkedList;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.tcp.TcpCacheManagerPeerProvider;
import si.nevensrok.common.ehcache.tcp.TcpConnectionEstablishedHandler;
import si.nevensrok.common.network.tcp.SslTcpNetworkClient;
import si.nevensrok.common.network.tcp.SslTcpNetworkServer;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.network.tcp.TcpNetworkServer;

public class TcpCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(TcpCacheManagerPeerProviderFactory.class);
    public static final String LISTEN_URL = "LISTEN_URL";

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        try {
            String[] providerUrls;
            String serverUrl = PropertyUtil.extractAndLogProperty((String)LISTEN_URL, (Properties)properties);
            URI serverUri = new URI(serverUrl);
            int serverPort = serverUri.getPort();
            TcpNetworkServer tcpNetworkServer = null;
            tcpNetworkServer = serverUrl.toLowerCase().startsWith("ssl://") ? new SslTcpNetworkServer() : new TcpNetworkServer();
            TcpConnectionEstablishedHandler tcpConnectionEstablishedHandler = new TcpConnectionEstablishedHandler(cacheManager);
            tcpNetworkServer.setPort(serverPort);
            tcpNetworkServer.setConnectionEstablishedHandler(tcpConnectionEstablishedHandler);
            LinkedList<TcpNetworkClient> tcpNetworkClients = new LinkedList<TcpNetworkClient>();
            for (String providerUrl : providerUrls = PropertyUtil.extractAndLogProperty((String)"providerURL", (Properties)properties).split("\\x7C")) {
                URI uri = new URI(providerUrl);
                String address = uri.getHost();
                int port = uri.getPort();
                TcpNetworkClient tcpNetworkClient = null;
                tcpNetworkClient = providerUrl.toLowerCase().startsWith("ssl://") ? new SslTcpNetworkClient() : new TcpNetworkClient();
                tcpNetworkClient.setAddress(address);
                tcpNetworkClient.setPort(port);
                tcpNetworkClients.add(tcpNetworkClient);
            }
            return new TcpCacheManagerPeerProvider(cacheManager, tcpNetworkServer, tcpNetworkClients);
        }
        catch (Exception e) {
            log.error("Error creating tcp cache manager peer provider", (Throwable)e);
            return null;
        }
    }
}

