/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.tcp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.common.AbstractCacheLoader;
import si.nevensrok.common.ehcache.common.FetchObjectMessage;
import si.nevensrok.common.network.tcp.TcpNetworkClient;

public class TcpCacheLoader
extends AbstractCacheLoader {
    private static final Logger log = LoggerFactory.getLogger(TcpCacheLoader.class);
    private Random random = new Random();
    private Ehcache cache;
    private List<TcpNetworkClient> tcpNetworkClients;
    private Status status = Status.STATUS_UNINITIALISED;

    public TcpCacheLoader(Ehcache cache, List<TcpNetworkClient> tcpNetworkClients) {
        this.cache = cache;
        this.tcpNetworkClients = tcpNetworkClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fetchObject(Object key) {
        ArrayList<TcpNetworkClient> clients = new ArrayList<TcpNetworkClient>(this.tcpNetworkClients);
        while (!clients.isEmpty()) {
            TcpNetworkClient tcpNetworkClient = (TcpNetworkClient)clients.remove(this.random.nextInt(clients.size()));
            try {
                TcpNetworkClient tcpNetworkClient2 = tcpNetworkClient;
                synchronized (tcpNetworkClient2) {
                    HashSet<Object> keys = new HashSet<Object>();
                    keys.add(key);
                    tcpNetworkClient.sendMessage(new FetchObjectMessage(this.cache.getName(), keys));
                    FetchObjectMessage fetchObjectMessage = (FetchObjectMessage)tcpNetworkClient.receiveMessage().getData();
                    return fetchObjectMessage.getValues().get(key);
                }
            }
            catch (Exception e) {
                log.debug("Error fetching data", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Object> fetchObjects(Set<Object> keys) {
        ArrayList<TcpNetworkClient> clients = new ArrayList<TcpNetworkClient>(this.tcpNetworkClients);
        while (!clients.isEmpty()) {
            TcpNetworkClient tcpNetworkClient = (TcpNetworkClient)clients.remove(this.random.nextInt(clients.size()));
            try {
                TcpNetworkClient tcpNetworkClient2 = tcpNetworkClient;
                synchronized (tcpNetworkClient2) {
                    tcpNetworkClient.sendMessage(new FetchObjectMessage(this.cache.getName(), keys));
                    FetchObjectMessage fetchObjectMessage = (FetchObjectMessage)tcpNetworkClient.receiveMessage().getData();
                    return fetchObjectMessage.getValues();
                }
            }
            catch (Exception e) {
                log.debug("Error fetching data", (Throwable)e);
            }
        }
        return null;
    }

    public void init() {
        for (TcpNetworkClient tcpNetworkClient : this.tcpNetworkClients) {
            try {
                tcpNetworkClient.afterPropertiesSet();
            }
            catch (Exception e) {
                log.error("Error opening tcp connection", (Throwable)e);
            }
        }
        this.status = Status.STATUS_ALIVE;
    }

    public void dispose() throws CacheException {
        if (this.tcpNetworkClients != null) {
            for (TcpNetworkClient tcpNetworkClient : this.tcpNetworkClients) {
                try {
                    tcpNetworkClient.destroy();
                }
                catch (Exception e) {
                    log.debug("Error closing tcp connection", (Throwable)e);
                }
            }
        }
        this.status = Status.STATUS_SHUTDOWN;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.cache.getName() + " TCPCacheLoader";
    }
}

