/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.tcp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;
import si.nevensrok.common.cache.ClearCacheMessage;
import si.nevensrok.common.cache.EvictCacheMessage;
import si.nevensrok.common.cache.PutCacheMessage;
import si.nevensrok.common.cache.memory.MemoryCache;
import si.nevensrok.common.cache.tcp.TcpCacheManager;

public class TcpCache
extends MemoryCache {
    private static final Logger log = LoggerFactory.getLogger(TcpCache.class);
    private TcpCacheManager tcpCacheManager;

    public TcpCache(String name, CacheSettings cacheSettings, TcpCacheManager tcpCacheManager) {
        super(name, cacheSettings);
        this.tcpCacheManager = tcpCacheManager;
    }

    @Override
    public void put(Object key, Object value) {
        try {
            CachedValue cachedValue = super.putAndReturn(key, value, System.currentTimeMillis());
            PutCacheMessage putCacheMessage = new PutCacheMessage(this.getName(), key, cachedValue);
            this.tcpCacheManager.sentMessageToAllNodes(putCacheMessage);
        }
        catch (Throwable e) {
            log.error("Error putting cache", e);
        }
    }

    @Override
    public void evict(Object key) {
        try {
            super.evict(key);
            EvictCacheMessage evictCacheMessage = new EvictCacheMessage(this.getName(), key);
            this.tcpCacheManager.sentMessageToAllNodes(evictCacheMessage);
        }
        catch (Throwable e) {
            log.error("Error evicting cache", e);
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
            ClearCacheMessage clearCacheMessage = new ClearCacheMessage(this.getName());
            this.tcpCacheManager.sentMessageToAllNodes(clearCacheMessage);
        }
        catch (Throwable e) {
            log.error("Error clearing cache", e);
        }
    }

    public synchronized void addCache(Object key, CachedValue cachedValue) {
        CachedValue existingValue = this.get(key);
        if (existingValue == null || existingValue.getCreatedAt() < cachedValue.getCreatedAt()) {
            super.putAndReturn(key, cachedValue.get(), cachedValue.getCreatedAt());
        }
    }

    public void evictCache(Object key) {
        super.evict(key);
    }

    public void clearCache() {
        super.clear();
    }
}

