/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.tcp;

import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.tcp.ConnectionEstablishedHandler;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkServer;
import si.nevensrok.common.remoting.tcp.ExecuteMethodMessage;
import si.nevensrok.common.remoting.tcp.MethodExecutedResponse;

public class TcpNetworkServiceExporter
extends RemoteInvocationBasedExporter
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TcpNetworkServiceExporter.class);
    private TcpNetworkServer[] tcpNetworkServers;
    private TaskExecutor taskExecutor = null;
    private boolean active = false;

    public void setTcpNetworkServer(TcpNetworkServer tcpNetworkServer) {
        this.tcpNetworkServers = new TcpNetworkServer[]{tcpNetworkServer};
    }

    public void setTcpNetworkServers(TcpNetworkServer[] tcpNetworkServers) {
        this.tcpNetworkServers = tcpNetworkServers;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.tcpNetworkServers == null) {
            throw new IllegalArgumentException("Property 'tcpNetworkServer' is required");
        }
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.getService() == null) {
            throw new IllegalArgumentException("Property 'service' is required");
        }
        final TcpNetworkServiceExporter exporter = this;
        this.active = true;
        for (TcpNetworkServer tcpNetworkServer : this.tcpNetworkServers) {
            final int port = tcpNetworkServer.getPort();
            tcpNetworkServer.setConnectionEstablishedHandler(new ConnectionEstablishedHandler(){

                public void connectionAccepted(final TcpNetworkConnection networkConnection) {
                    Thread thread = new Thread("Request handler thread on port " + port){

                        @Override
                        public void run() {
                            while (TcpNetworkServiceExporter.this.active) {
                                try {
                                    final NetworkMessage networkMessage = networkConnection.receiveMessage();
                                    Runnable runnable = new Runnable(){

                                        @Override
                                        public void run() {
                                            ExecuteMethodMessage executeMethodMessage = (ExecuteMethodMessage)networkMessage.getData();
                                            String methodName = executeMethodMessage.getMethodName();
                                            Class[] parameterTypes = executeMethodMessage.getParameterTypes();
                                            Object[] arguments = executeMethodMessage.getArguments();
                                            MethodExecutedResponse methodExecutedResponse = new MethodExecutedResponse();
                                            methodExecutedResponse.setMessageId(executeMethodMessage.getMessageId());
                                            try {
                                                Object result = exporter.invoke(methodName, parameterTypes, arguments);
                                                methodExecutedResponse.setResult(result);
                                            }
                                            catch (InvocationTargetException e) {
                                                methodExecutedResponse.setThrowable(e.getCause());
                                            }
                                            catch (Exception e) {
                                                log.trace("Error executing method", (Throwable)e);
                                            }
                                            try {
                                                networkConnection.sendMessage((Object)methodExecutedResponse);
                                            }
                                            catch (Exception e) {
                                                log.trace("Error sending message reply", (Throwable)e);
                                            }
                                        }
                                    };
                                    if (TcpNetworkServiceExporter.this.taskExecutor != null) {
                                        TcpNetworkServiceExporter.this.taskExecutor.execute(runnable);
                                        continue;
                                    }
                                    runnable.run();
                                }
                                catch (Exception e) {
                                    log.trace("Error handling message", (Throwable)e);
                                }
                            }
                        }
                    };
                    thread.setDaemon(true);
                    thread.start();
                }
            });
        }
    }

    public void destroy() throws Exception {
        this.active = false;
    }

    private Object invoke(String methodName, Class<?>[] parameterTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        RemoteInvocation remoteInvocation = new RemoteInvocation(methodName, (Class[])parameterTypes, arguments);
        return super.invoke(remoteInvocation, this.getService());
    }
}

