/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.vertical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.gui.InfoPanel;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalDuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalFightPointsPanel;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalNewazaPointsPanel;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class VerticalMatchPanel
extends JPanel
implements InitializingBean,
ApplicationContextAware,
MatchPanel {
    private static final long serialVersionUID = -1642637447560399339L;
    private static final NumberFormat fightPointsFormat = new DecimalFormat("0", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final NumberFormat duoPointsFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    private JPanel competitorsPanel = new JPanel();
    private JPanel competitor1Panel = new JPanel();
    private JPanel competitor2Panel = new JPanel();
    private JLabel points1label = new JLabel();
    private JLabel points2label = new JLabel();
    private JPanel competitor1TopPanel = new JPanel();
    private JLabel name1label = new JLabel();
    private JLabel club1label = new JLabel();
    private JPanel competitor2TopPanel = new JPanel();
    private JLabel name2label = new JLabel();
    private JLabel club2label = new JLabel();
    private static final Font nameFont = new Font("Serif", 1, 50);
    private static final Font pointsFont = new Font("Serif", 1, 120);
    private JPanel bottomPanel = new JPanel();
    private InfoPanel infoPanel;
    private VerticalFightPointsPanel[] fightPointsPanel;
    private VerticalDuoPointsPanel[] duoPointsPanel;
    private VerticalNewazaPointsPanel[] newazaPointsPanels;
    private MatchData matchData;
    private JFrame mainWindow;
    boolean flipped = false;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setInfoPanel(InfoPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    public void setFightPointsPanel(VerticalFightPointsPanel[] fightPointsPanel) {
        this.fightPointsPanel = fightPointsPanel;
    }

    public void setDuoPointsPanel(VerticalDuoPointsPanel[] duoPointsPanel) {
        this.duoPointsPanel = duoPointsPanel;
    }

    public void setNewazaPointsPanels(VerticalNewazaPointsPanel[] newazaPointsPanels) {
        this.newazaPointsPanels = newazaPointsPanels;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setMainWindow(JFrame mainWindow) {
        this.mainWindow = mainWindow;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public VerticalMatchPanel() {
        this.setLayout(new BorderLayout());
        this.competitorsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)this.competitorsPanel, "Center");
        this.competitorsPanel.add(this.competitor1Panel);
        this.competitor1Panel.setLayout(new BorderLayout());
        this.competitor1TopPanel.setLayout(new GridLayout(2, 1));
        this.competitor1TopPanel.add(this.name1label);
        this.competitor1TopPanel.add(this.club1label);
        this.competitor1Panel.add((Component)this.competitor1TopPanel, "North");
        this.competitor1Panel.add((Component)this.points1label, "Center");
        this.competitorsPanel.add(this.competitor2Panel);
        this.competitor2Panel.setLayout(new BorderLayout());
        this.competitor2TopPanel.setLayout(new GridLayout(2, 1));
        this.competitor2TopPanel.add(this.name2label);
        this.competitor2TopPanel.add(this.club2label);
        this.competitor2Panel.add((Component)this.competitor2TopPanel, "North");
        this.competitor2Panel.add((Component)this.points2label, "Center");
        this.bottomPanel.setLayout(new GridLayout(1, 3));
        this.add((Component)this.bottomPanel, "South");
    }

    public void afterPropertiesSet() throws Exception {
        this.redrawElements();
    }

    @Override
    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean changeSide = VerticalMatchPanel.this.flipped != VerticalMatchPanel.this.matchData.isFlipCompetitors();
                VerticalMatchPanel.this.flipped = VerticalMatchPanel.this.matchData.isFlipCompetitors();
                if (changeSide) {
                    VerticalMatchPanel.this.competitorsPanel.remove(VerticalMatchPanel.this.competitor1Panel);
                    VerticalMatchPanel.this.competitorsPanel.remove(VerticalMatchPanel.this.competitor2Panel);
                    if (VerticalMatchPanel.this.flipped) {
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor2Panel);
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor1Panel);
                    } else {
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor1Panel);
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor2Panel);
                    }
                }
                VerticalMatchPanel.this.points1label.setOpaque(true);
                VerticalMatchPanel.this.points1label.setForeground(Constants.competitor1fgColor);
                VerticalMatchPanel.this.points1label.setBackground(Constants.competitor1bgColor);
                VerticalMatchPanel.this.points1label.setHorizontalAlignment(0);
                FontSizeUtil.refitFontSize(pointsFont, VerticalMatchPanel.this.points1label);
                VerticalMatchPanel.this.points2label.setOpaque(true);
                VerticalMatchPanel.this.points2label.setForeground(Constants.competitor2fgColor);
                VerticalMatchPanel.this.points2label.setBackground(Constants.competitor2bgColor);
                VerticalMatchPanel.this.points2label.setHorizontalAlignment(0);
                FontSizeUtil.refitFontSize(pointsFont, VerticalMatchPanel.this.points2label);
                int topHeight = VerticalMatchPanel.this.mainWindow.getHeight() / 8;
                if (topHeight < 70) {
                    topHeight = 70;
                }
                VerticalMatchPanel.this.competitor1TopPanel.setBackground(Constants.competitor1bgColor);
                VerticalMatchPanel.this.name1label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.name1label.setForeground(Constants.competitor1fgColor);
                VerticalMatchPanel.this.name1label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.club1label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.club1label.setForeground(Constants.competitor1fgColor);
                VerticalMatchPanel.this.club1label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.competitor2TopPanel.setBackground(Constants.competitor2bgColor);
                VerticalMatchPanel.this.name2label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.name2label.setForeground(Constants.competitor2fgColor);
                VerticalMatchPanel.this.name2label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.club2label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.club2label.setForeground(Constants.competitor2fgColor);
                VerticalMatchPanel.this.club2label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.infoPanel.setPreferredSize(new Dimension(190, 0));
                VerticalMatchPanel.this.name1label.setText(VerticalMatchPanel.this.matchData.getName1());
                FontSizeUtil.refitFontSize(nameFont, VerticalMatchPanel.this.name1label);
                VerticalMatchPanel.this.club1label.setText(VerticalMatchPanel.this.matchData.getClub1());
                FontSizeUtil.refitFontSize(nameFont, VerticalMatchPanel.this.club1label);
                VerticalMatchPanel.this.name2label.setText(VerticalMatchPanel.this.matchData.getName2());
                FontSizeUtil.refitFontSize(nameFont, VerticalMatchPanel.this.name2label);
                VerticalMatchPanel.this.club2label.setText(VerticalMatchPanel.this.matchData.getClub2());
                FontSizeUtil.refitFontSize(nameFont, VerticalMatchPanel.this.club2label);
                int bottomHeight = VerticalMatchPanel.this.mainWindow.getHeight() / 3;
                if (bottomHeight < 100) {
                    bottomHeight = 100;
                }
                VerticalMatchPanel.this.bottomPanel.setPreferredSize(new Dimension(0, bottomHeight));
                if (VerticalMatchPanel.this.flipped) {
                    VerticalMatchPanel.this.competitorsPanel.setBackground(Constants.competitor1bgColor);
                    VerticalMatchPanel.this.bottomPanel.setBackground(Constants.competitor1bgColor);
                } else {
                    VerticalMatchPanel.this.competitorsPanel.setBackground(Constants.competitor2bgColor);
                    VerticalMatchPanel.this.bottomPanel.setBackground(Constants.competitor2bgColor);
                }
                if (VerticalMatchPanel.this.matchData.getTableType() == TableType.FIGHT) {
                    boolean change = true;
                    for (Component component : VerticalMatchPanel.this.bottomPanel.getComponents()) {
                        if (component != VerticalMatchPanel.this.fightPointsPanel[0]) continue;
                        change = false;
                        break;
                    }
                    if (change || changeSide) {
                        VerticalMatchPanel.this.bottomPanel.removeAll();
                        if (VerticalMatchPanel.this.flipped) {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel[1], 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel[0], 2);
                        } else {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel[0], 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel[1], 2);
                        }
                        VerticalMatchPanel.this.revalidate();
                        VerticalMatchPanel.this.repaint();
                        VerticalMatchPanel.this.mainWindow.requestFocus();
                    }
                } else if (VerticalMatchPanel.this.matchData.getTableType() == TableType.DUO) {
                    boolean change = true;
                    for (Component component : VerticalMatchPanel.this.bottomPanel.getComponents()) {
                        if (component != VerticalMatchPanel.this.duoPointsPanel[0]) continue;
                        change = false;
                        break;
                    }
                    if (change || changeSide) {
                        VerticalMatchPanel.this.bottomPanel.removeAll();
                        if (VerticalMatchPanel.this.flipped) {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel[1], 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel[0], 2);
                        } else {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel[0], 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel[1], 2);
                        }
                        VerticalMatchPanel.this.revalidate();
                        VerticalMatchPanel.this.repaint();
                    }
                } else if (VerticalMatchPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                    boolean change = true;
                    for (Component component : VerticalMatchPanel.this.bottomPanel.getComponents()) {
                        if (component != VerticalMatchPanel.this.newazaPointsPanels[0]) continue;
                        change = false;
                        break;
                    }
                    if (change || changeSide) {
                        VerticalMatchPanel.this.bottomPanel.removeAll();
                        if (VerticalMatchPanel.this.flipped) {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels[1], 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels[0], 2);
                        } else {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels[0], 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels[1], 2);
                        }
                        VerticalMatchPanel.this.revalidate();
                        VerticalMatchPanel.this.repaint();
                        VerticalMatchPanel.this.mainWindow.requestFocus();
                    }
                }
                VerticalMatchPanel.this.fightPointsPanel[0].redrawElements();
                VerticalMatchPanel.this.fightPointsPanel[1].redrawElements();
                VerticalMatchPanel.this.duoPointsPanel[0].redrawElements();
                VerticalMatchPanel.this.duoPointsPanel[1].redrawElements();
                VerticalMatchPanel.this.newazaPointsPanels[0].redrawElements();
                VerticalMatchPanel.this.newazaPointsPanels[1].redrawElements();
                VerticalMatchPanel.this.infoPanel.redrawElements();
            }
        });
    }

    @Override
    public void setPoints1(float points) {
        final String text = this.matchData.getTableType() == TableType.FIGHT || this.matchData.getTableType() == TableType.NEWAZA ? fightPointsFormat.format(points) : duoPointsFormat.format(points);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.points1label.setText(text);
                FontSizeUtil.refitFontSize(pointsFont, VerticalMatchPanel.this.points1label);
            }
        });
    }

    @Override
    public void setPoints2(float points) {
        final String text = this.matchData.getTableType() == TableType.FIGHT || this.matchData.getTableType() == TableType.NEWAZA ? fightPointsFormat.format(points) : duoPointsFormat.format(points);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.points2label.setText(text);
                FontSizeUtil.refitFontSize(pointsFont, VerticalMatchPanel.this.points2label);
            }
        });
    }

    @Override
    public void setWinner1() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.name1label.setText(VerticalMatchPanel.this.getLanguageText("text.winner"));
                FontSizeUtil.refitFontSize(nameFont, VerticalMatchPanel.this.name1label);
                VerticalMatchPanel.this.club1label.setText("");
                VerticalMatchPanel.this.name2label.setText("");
                VerticalMatchPanel.this.club2label.setText("");
            }
        });
    }

    @Override
    public void setWinner2() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.name2label.setText(VerticalMatchPanel.this.getLanguageText("text.winner"));
                FontSizeUtil.refitFontSize(nameFont, VerticalMatchPanel.this.name2label);
                VerticalMatchPanel.this.name1label.setText("");
                VerticalMatchPanel.this.club1label.setText("");
                VerticalMatchPanel.this.club2label.setText("");
            }
        });
    }
}

