/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.distributed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ServiceInfo {
    private Class<?> serviceInterface;
    private Object service;
    private long[] failTimeouts;
    private long nextAttemptTime = 0L;
    private long firstFailureTime = 0L;

    public ServiceInfo(Class<?> serviceInterface, Object service, long[] failTimeouts) {
        this.serviceInterface = serviceInterface;
        this.service = service;
        this.failTimeouts = failTimeouts;
    }

    public long getNextAttemptTime() {
        return this.nextAttemptTime;
    }

    public synchronized void resetFailAttempts() {
        this.nextAttemptTime = 0L;
        this.firstFailureTime = 0L;
    }

    public synchronized void addAttemptFailure() {
        long currentTime = System.currentTimeMillis();
        if (this.firstFailureTime == 0L) {
            this.firstFailureTime = currentTime;
        }
        long failTimeout = this.failTimeouts[this.failTimeouts.length - 1];
        long lastAttemptDiff = currentTime - this.firstFailureTime;
        for (int j = 0; j < this.failTimeouts.length; ++j) {
            if (lastAttemptDiff <= this.failTimeouts[j]) {
                failTimeout = this.failTimeouts[j];
                break;
            }
            lastAttemptDiff -= this.failTimeouts[j];
        }
        this.nextAttemptTime = currentTime + failTimeout;
    }

    public Object getService() {
        return this.service;
    }

    public Object execute(Method targetMethod, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Method method = this.serviceInterface.getMethod(targetMethod.getName(), targetMethod.getParameterTypes());
        return method.invoke(this.service, args);
    }
}

