/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.rules.rules1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorPoints;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.rules.rules1.TableItem;

public class CompetitionRules1
implements CompetitionRules {
    private static final Logger log = LoggerFactory.getLogger(CompetitionRules1.class);
    public static final float fullIpponPoints = 50.0f;
    public static final float newazaFinishingMovePoints = 100.0f;

    public String getName() {
        return "Rules1";
    }

    public Competitor getMatchWinner(Match match, Set<MatchPoint> points) {
        if (match.getType() == Match.Type.FIGHT) {
            float ippons2;
            int ipponCategories2;
            float points2;
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor2();
            }
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor1();
            }
            if (this.isFullIpponFor(CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor1();
            }
            if (this.isFullIpponFor(CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor2();
            }
            float points1 = this.sumFightPointsFor(CompetitorType.COMPETITOR1, points);
            if (points1 > (points2 = this.sumFightPointsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor1();
            }
            if (points2 > points1) {
                return match.getCompetitor2();
            }
            int ipponCategories1 = this.sumIpponCategoriesFor(CompetitorType.COMPETITOR1, points);
            if (ipponCategories1 > (ipponCategories2 = this.sumIpponCategoriesFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor1();
            }
            if (ipponCategories2 > ipponCategories1) {
                return match.getCompetitor2();
            }
            float ippons1 = this.sumIpponsFor(CompetitorType.COMPETITOR1, points);
            if (ippons1 > (ippons2 = this.sumIpponsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor1();
            }
            if (ippons2 > ippons1) {
                return match.getCompetitor2();
            }
            return null;
        }
        if (match.getType() == Match.Type.DUO) {
            float points2;
            float points1 = this.sumDuoPointsFor(CompetitorType.COMPETITOR1, points);
            if (points1 > (points2 = this.sumDuoPointsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor1();
            }
            if (points2 > points1) {
                return match.getCompetitor2();
            }
            return null;
        }
        if (match.getType() == Match.Type.NEWAZA) {
            float advantages2;
            float points2;
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor2();
            }
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor1();
            }
            if (this.isFinishingMove(CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor1();
            }
            if (this.isFinishingMove(CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor2();
            }
            float points1 = this.sumNewazaPointsFor(CompetitorType.COMPETITOR1, points);
            if (points1 > (points2 = this.sumNewazaPointsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor1();
            }
            if (points2 > points1) {
                return match.getCompetitor2();
            }
            float advantages1 = this.sumNewazaAdvantagesFor(CompetitorType.COMPETITOR1, points);
            if (advantages1 > (advantages2 = this.sumNewazaAdvantagesFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor1();
            }
            if (advantages2 > advantages1) {
                return match.getCompetitor2();
            }
            return null;
        }
        log.warn("Unknown match type for match {}", (Object)match);
        return null;
    }

    public Competitor getMatchLoser(Match match, Set<MatchPoint> points) {
        if (match.getType() == Match.Type.FIGHT) {
            float ippons2;
            int ipponCategories2;
            float points2;
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor1();
            }
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor2();
            }
            if (this.isFullIpponFor(CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor2();
            }
            if (this.isFullIpponFor(CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor1();
            }
            float points1 = this.sumFightPointsFor(CompetitorType.COMPETITOR1, points);
            if (points1 > (points2 = this.sumFightPointsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor2();
            }
            if (points2 > points1) {
                return match.getCompetitor1();
            }
            int ipponCategories1 = this.sumIpponCategoriesFor(CompetitorType.COMPETITOR1, points);
            if (ipponCategories1 > (ipponCategories2 = this.sumIpponCategoriesFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor2();
            }
            if (ipponCategories2 > ipponCategories1) {
                return match.getCompetitor1();
            }
            float ippons1 = this.sumIpponsFor(CompetitorType.COMPETITOR1, points);
            if (ippons1 > (ippons2 = this.sumIpponsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor2();
            }
            if (ippons2 > ippons1) {
                return match.getCompetitor1();
            }
            return null;
        }
        if (match.getType() == Match.Type.DUO) {
            float points2;
            float points1 = this.sumDuoPointsFor(CompetitorType.COMPETITOR1, points);
            if (points1 > (points2 = this.sumDuoPointsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor2();
            }
            if (points2 > points1) {
                return match.getCompetitor1();
            }
            return null;
        }
        if (match.getType() == Match.Type.NEWAZA) {
            float advantage2;
            float points2;
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor1();
            }
            if (this.isDisqualificationFor(match.getType(), CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor2();
            }
            if (this.isFinishingMove(CompetitorType.COMPETITOR1, points)) {
                return match.getCompetitor2();
            }
            if (this.isFinishingMove(CompetitorType.COMPETITOR2, points)) {
                return match.getCompetitor1();
            }
            float points1 = this.sumNewazaPointsFor(CompetitorType.COMPETITOR1, points);
            if (points1 > (points2 = this.sumNewazaPointsFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor2();
            }
            if (points2 > points1) {
                return match.getCompetitor1();
            }
            float advantage1 = this.sumNewazaAdvantagesFor(CompetitorType.COMPETITOR1, points);
            if (advantage1 > (advantage2 = this.sumNewazaAdvantagesFor(CompetitorType.COMPETITOR2, points))) {
                return match.getCompetitor2();
            }
            if (advantage2 > advantage1) {
                return match.getCompetitor1();
            }
            return null;
        }
        log.warn("Unknown match type for match {}", (Object)match);
        return null;
    }

    public boolean isDisqualificationFor(Match.Type matchType, CompetitorType competitorType, Set<MatchPoint> points) {
        float shidos;
        float hansokumake = this.getPoints(competitorType, PointType.HANSOKUMAKE, points);
        if (hansokumake > 0.0f) {
            return true;
        }
        return matchType == Match.Type.NEWAZA && (shidos = this.getPoints(competitorType, PointType.SHIDO, points)) >= 4.0f;
    }

    public boolean isFullIpponFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon3p = this.getPoints(competitorType, PointType.IPPON3POINTS, points);
        return ippon1 > 0.0f && ippon2 > 0.0f && (ippon3 > 0.0f || ippon3p > 0.0f);
    }

    public boolean isFinishingMove(CompetitorType competitorType, Set<MatchPoint> points) {
        float finishingMove = this.getPoints(competitorType, PointType.FINISHINGMOVE, points);
        float points100 = this.getPoints(competitorType, PointType.POINT100, points);
        return finishingMove > 0.0f || points100 > 0.0f;
    }

    public float sumPointsFor(Match.Type matchType, CompetitorType competitorType, Set<MatchPoint> points) {
        if (matchType == Match.Type.FIGHT) {
            CompetitorType other = CompetitorType.COMPETITOR1;
            if (competitorType == CompetitorType.COMPETITOR1) {
                other = CompetitorType.COMPETITOR2;
            }
            if (this.isDisqualificationFor(matchType, competitorType, points)) {
                return 0.0f;
            }
            if (this.isDisqualificationFor(matchType, other, points)) {
                return 50.0f;
            }
            if (this.isFullIpponFor(competitorType, points)) {
                return 50.0f;
            }
            if (this.isFullIpponFor(other, points)) {
                return 0.0f;
            }
            return this.sumFightPointsFor(competitorType, points);
        }
        if (matchType == Match.Type.DUO) {
            return this.sumDuoPointsFor(competitorType, points);
        }
        if (matchType == Match.Type.NEWAZA) {
            CompetitorType other = CompetitorType.COMPETITOR1;
            if (competitorType == CompetitorType.COMPETITOR1) {
                other = CompetitorType.COMPETITOR2;
            }
            if (this.isDisqualificationFor(matchType, competitorType, points)) {
                return 0.0f;
            }
            if (this.isDisqualificationFor(matchType, other, points)) {
                return 100.0f;
            }
            if (this.isFinishingMove(competitorType, points)) {
                return 100.0f;
            }
            if (this.isFinishingMove(other, points)) {
                return 0.0f;
            }
            return this.sumNewazaPointsFor(competitorType, points);
        }
        log.warn("Unknown match type {}", (Object)matchType);
        return 0.0f;
    }

    public float sumIpponsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon3p = this.getPoints(competitorType, PointType.IPPON3POINTS, points);
        return ippon1 + ippon2 + ippon3 + ippon3p;
    }

    public void setPlacingsInTable(Table table) {
        ArrayList<TableItem> sorted = new ArrayList<TableItem>(5);
        for (int i = 0; i < table.getRows().length; ++i) {
            Table.Row row = table.getRows()[i];
            sorted.add(new TableItem(i, row.getWins(), row.getFullIpponWins(), row.getPointsGained().floatValue()));
        }
        Collections.sort(sorted, new Comparator<TableItem>(){

            @Override
            public int compare(TableItem o1, TableItem o2) {
                if (o1.getWins() > o2.getWins()) {
                    return -1;
                }
                if (o1.getWins() < o2.getWins()) {
                    return 1;
                }
                return 0;
            }
        });
        HashMap<Integer, HashSet<Integer>> samePlaces = new HashMap<Integer, HashSet<Integer>>();
        int place = 0;
        for (int i = 0; i < sorted.size(); ++i) {
            ((TableItem)sorted.get(i)).setPlace(++place);
            if (i <= 0 || ((TableItem)sorted.get(i - 1)).getWins() != ((TableItem)sorted.get(i)).getWins()) continue;
            ((TableItem)sorted.get(i)).setPlace(((TableItem)sorted.get(i - 1)).getPlace());
            ((TableItem)sorted.get(i)).setPlaceShared(true);
            ((TableItem)sorted.get(i - 1)).setPlaceShared(true);
            HashSet<Integer> sameMatchesNumbers = (HashSet<Integer>)samePlaces.get(((TableItem)sorted.get(i)).getPlace());
            if (sameMatchesNumbers == null) {
                sameMatchesNumbers = new HashSet<Integer>();
                samePlaces.put(((TableItem)sorted.get(i)).getPlace(), sameMatchesNumbers);
            }
            sameMatchesNumbers.add(((TableItem)sorted.get(i)).getN());
            sameMatchesNumbers.add(((TableItem)sorted.get(i - 1)).getN());
        }
        for (TableItem tableItem : sorted) {
            if (!tableItem.isPlaceShared()) continue;
            Table.Row row = table.getRows()[tableItem.getN()];
            Set sameMatchesNumbers = (Set)samePlaces.get(tableItem.getPlace());
            int winsVsSame = row.getWinsVs(sameMatchesNumbers);
            tableItem.setWinsVsSame(winsVsSame);
        }
        Collections.sort(sorted, new Comparator<TableItem>(){

            @Override
            public int compare(TableItem o1, TableItem o2) {
                if (o1.getWins() > o2.getWins()) {
                    return -1;
                }
                if (o1.getWins() < o2.getWins()) {
                    return 1;
                }
                if (o1.getWinsVsSame() > o2.getWinsVsSame()) {
                    return -1;
                }
                if (o1.getWinsVsSame() < o2.getWinsVsSame()) {
                    return 1;
                }
                if (o1.getFullIpponWins() > o2.getFullIpponWins()) {
                    return -1;
                }
                if (o1.getFullIpponWins() < o2.getFullIpponWins()) {
                    return 1;
                }
                if (o1.getPoints() > o2.getPoints()) {
                    return -1;
                }
                if (o1.getPoints() < o2.getPoints()) {
                    return 1;
                }
                return 0;
            }
        });
        place = 0;
        for (int i = 0; i < sorted.size(); ++i) {
            ((TableItem)sorted.get(i)).setPlace(++place);
            if (i <= 0 || ((TableItem)sorted.get(i - 1)).getWins() != ((TableItem)sorted.get(i)).getWins() || ((TableItem)sorted.get(i - 1)).getWinsVsSame() != ((TableItem)sorted.get(i)).getWinsVsSame() || ((TableItem)sorted.get(i - 1)).getFullIpponWins() != ((TableItem)sorted.get(i)).getFullIpponWins() || ((TableItem)sorted.get(i - 1)).getPoints() != ((TableItem)sorted.get(i)).getPoints()) continue;
            ((TableItem)sorted.get(i)).setPlace(((TableItem)sorted.get(i - 1)).getPlace());
        }
        for (TableItem tableItem : sorted) {
            table.getRows()[tableItem.getN()].setPlacing(Integer.valueOf(tableItem.getPlace()));
        }
    }

    public ClubCompetitorPoints getPointsForClub(Club club, Map<Competitor, Integer> placings, Map<Integer, Integer> pointsForPlace, boolean includeOneCompetitor, boolean includeSameClub) {
        int topPlace = Integer.MAX_VALUE;
        Integer points = null;
        if (placings.size() > 0) {
            boolean multipleClubsRepresented;
            HashSet<Long> clubIds = new HashSet<Long>();
            for (Map.Entry<Competitor, Integer> competitorPlacing : placings.entrySet()) {
                clubIds.add(competitorPlacing.getKey().getClub().getClubId());
                if (!club.getClubId().equals(competitorPlacing.getKey().getClub().getClubId()) || competitorPlacing.getValue() >= topPlace) continue;
                topPlace = competitorPlacing.getValue();
            }
            boolean bl = multipleClubsRepresented = clubIds.size() > 1;
            if ((placings.size() > 1 || includeOneCompetitor) && (multipleClubsRepresented || includeSameClub)) {
                if (pointsForPlace != null) {
                    points = pointsForPlace.get(topPlace);
                }
                if (points == null) {
                    switch (topPlace) {
                        case 1: {
                            points = 10;
                            break;
                        }
                        case 2: {
                            points = 7;
                            break;
                        }
                        case 3: {
                            points = 5;
                            break;
                        }
                        case 4: {
                            points = 4;
                            break;
                        }
                        case 5: {
                            points = 3;
                            break;
                        }
                        case 6: {
                            points = 2;
                            break;
                        }
                        case 7: {
                            points = 1;
                        }
                    }
                }
            }
        }
        if (points == null || points < 0) {
            points = 0;
        }
        ClubCompetitorPoints clubCompetitorPoints = new ClubCompetitorPoints();
        clubCompetitorPoints.setPoints(points);
        clubCompetitorPoints.setTopPlace(Integer.valueOf(topPlace));
        return clubCompetitorPoints;
    }

    private float getPoints(CompetitorType competitorType, PointType pointType, Set<MatchPoint> points) {
        float value = 0.0f;
        for (MatchPoint matchPoint : points) {
            if (matchPoint.getCompetitor() != competitorType || matchPoint.getPointType() != pointType) continue;
            value = Math.max(value, matchPoint.getPoints().floatValue());
        }
        return value;
    }

    private float getPoints(CompetitorType competitorType, int round, int judge, Set<MatchPoint> points) {
        float value = 0.0f;
        for (MatchPoint matchPoint : points) {
            if (matchPoint.getCompetitor() != competitorType || matchPoint.getPointType() != PointType.JUDGE || matchPoint.getRound() != round || matchPoint.getJudge() != judge) continue;
            value = Math.max(value, matchPoint.getPoints().floatValue());
        }
        return value;
    }

    private float sumFightPointsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float wazari = this.getPoints(competitorType, PointType.WAZARI, points);
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon3p = this.getPoints(competitorType, PointType.IPPON3POINTS, points);
        return wazari + ippon1 * 2.0f + ippon2 * 2.0f + ippon3 * 2.0f + ippon3p * 3.0f;
    }

    private float sumDuoPointsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float sum = 0.0f;
        for (int round = 1; round <= 5; ++round) {
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (int judge = 1; judge <= 5; ++judge) {
                float p = this.getPoints(competitorType, round, judge, points);
                sum += p;
                if (p > max) {
                    max = p;
                }
                if (!(p < min)) continue;
                min = p;
            }
            sum -= min + max;
        }
        sum = (float)Math.round(sum * 100.0f) / 100.0f;
        return sum;
    }

    private int sumIpponCategoriesFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon3p = this.getPoints(competitorType, PointType.IPPON3POINTS, points);
        return (ippon1 > 0.0f ? 1 : 0) + (ippon2 > 0.0f ? 1 : 0) + (ippon3 > 0.0f || ippon3p > 0.0f ? 1 : 0);
    }

    private float sumNewazaPointsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float point1 = this.getPoints(competitorType, PointType.POINT1, points);
        float point2 = this.getPoints(competitorType, PointType.POINT2, points);
        float point3 = this.getPoints(competitorType, PointType.POINT3, points);
        float point4 = this.getPoints(competitorType, PointType.POINT4, points);
        float point5 = this.getPoints(competitorType, PointType.POINT5, points);
        float point6 = this.getPoints(competitorType, PointType.POINT6, points);
        float point7 = this.getPoints(competitorType, PointType.POINT7, points);
        float point100 = this.getPoints(competitorType, PointType.POINT100, points);
        if (point100 > 0.0f) {
            return 100.0f;
        }
        return point1 + point2 * 2.0f + point3 * 3.0f + point4 * 4.0f + point5 * 5.0f + point6 * 6.0f + point7 * 7.0f;
    }

    private float sumNewazaAdvantagesFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float advantage = this.getPoints(competitorType, PointType.ADVANTAGE, points);
        return advantage;
    }
}

