/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.captcha.simple;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class WordRenderer
implements nl.captcha.text.renderer.WordRenderer {
    private static final List<Color> defaultColors = new LinkedList<Color>();
    private static final List<Font> defaultFonts = new LinkedList<Font>();
    private Random random = new Random();
    private List<Color> colors;
    private List<Font> fonts;

    public WordRenderer() {
        this(defaultColors, defaultFonts);
    }

    public WordRenderer(List<Color> colors, List<Font> fonts) {
        this.colors = colors;
        this.fonts = fonts;
    }

    public void render(String word, BufferedImage image) {
        if (word.isEmpty()) {
            return;
        }
        Graphics2D graphics = image.createGraphics();
        int charImageWidth = image.getWidth() / word.length();
        for (int i = 0; i < word.length(); ++i) {
            BufferedImage charImage = new BufferedImage(charImageWidth, image.getHeight(), 2);
            Graphics2D charImageGraphics = charImage.createGraphics();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            charImageGraphics.setRenderingHints(renderingHints);
            char c = word.charAt(i);
            if (!this.colors.isEmpty()) {
                charImageGraphics.setColor(this.colors.get(this.random.nextInt(this.colors.size())));
            }
            if (!this.fonts.isEmpty()) {
                charImageGraphics.setFont(this.fonts.get(this.random.nextInt(this.fonts.size())));
            }
            int x = Math.round((float)charImageWidth * 0.08f) + this.random.nextInt(Math.round((float)charImageWidth * 0.08f));
            int y = image.getHeight() - Math.round((float)image.getHeight() * 0.1f) - this.random.nextInt(Math.round((float)image.getHeight() * 0.4f));
            int rotateAngle = -20 + this.random.nextInt(40);
            charImageGraphics.rotate(Math.toRadians(rotateAngle), charImage.getWidth() / 2, charImage.getHeight() / 2);
            charImageGraphics.drawString(String.valueOf(c), x, y);
            graphics.drawImage((Image)charImage, i * charImageWidth, 0, null);
            charImageGraphics.dispose();
        }
    }

    static {
        defaultColors.add(Color.BLACK);
        defaultFonts.add(new Font("Arial", 1, 40));
    }
}

