/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.jms;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;
import si.nevensrok.common.cache.ClearCacheMessage;
import si.nevensrok.common.cache.EvictCacheMessage;
import si.nevensrok.common.cache.PutCacheMessage;
import si.nevensrok.common.cache.memory.MemoryCache;
import si.nevensrok.common.utils.ObjectUtil;

public class JmsCache
extends MemoryCache {
    private static final Logger log = LoggerFactory.getLogger(JmsCache.class);
    private Session session;
    private MessageProducer messageProducer;

    public JmsCache(String name, CacheSettings cacheSettings, Session session, MessageProducer messageProducer) {
        super(name, cacheSettings);
        this.session = session;
        this.messageProducer = messageProducer;
    }

    @Override
    public void put(Object key, Object value) {
        try {
            CachedValue cachedValue = super.putAndReturn(key, value, System.currentTimeMillis());
            PutCacheMessage putCacheMessage = new PutCacheMessage(this.getName(), key, cachedValue);
            BytesMessage message = this.session.createBytesMessage();
            message.writeBytes(ObjectUtil.serializeObject(putCacheMessage));
            this.messageProducer.send((Message)message);
        }
        catch (Throwable e) {
            log.error("Error putting cache", e);
        }
    }

    @Override
    public void evict(Object key) {
        try {
            super.evict(key);
            EvictCacheMessage evictCacheMessage = new EvictCacheMessage(this.getName(), key);
            BytesMessage message = this.session.createBytesMessage();
            message.writeBytes(ObjectUtil.serializeObject(evictCacheMessage));
            this.messageProducer.send((Message)message);
        }
        catch (Throwable e) {
            log.error("Error evicting cache", e);
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
            ClearCacheMessage clearCacheMessage = new ClearCacheMessage(this.getName());
            BytesMessage message = this.session.createBytesMessage();
            message.writeBytes(ObjectUtil.serializeObject(clearCacheMessage));
            this.messageProducer.send((Message)message);
        }
        catch (Throwable e) {
            log.error("Error clearing cache", e);
        }
    }

    public synchronized void addCache(Object key, CachedValue cachedValue) {
        CachedValue existingValue = this.get(key);
        if (existingValue == null || existingValue.getCreatedAt() < cachedValue.getCreatedAt()) {
            super.putAndReturn(key, cachedValue.get(), cachedValue.getCreatedAt());
        }
    }

    public void evictCache(Object key) {
        super.evict(key);
    }

    public void clearCache() {
        super.clear();
    }
}

