/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.usage;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.usage.LogLevel;
import si.nevensrok.common.usage.MethodInfo;
import si.nevensrok.common.usage.UsageRecorder;

public class LogUsageRecorder
implements UsageRecorder {
    private Logger usageLogger;
    private LogLevel logLevel;

    public LogUsageRecorder() {
        this.usageLogger = LoggerFactory.getLogger(LogUsageRecorder.class);
        this.logLevel = LogLevel.INFO;
    }

    public LogUsageRecorder(String loggerName) {
        this.usageLogger = LoggerFactory.getLogger((String)loggerName);
        this.logLevel = LogLevel.INFO;
    }

    public LogUsageRecorder(String loggerName, LogLevel logLevel) {
        this.usageLogger = LoggerFactory.getLogger((String)loggerName);
        this.logLevel = logLevel;
    }

    @Override
    public void logUsageRecords(List<MethodInfo> methodInfos) {
        for (MethodInfo methodInfo : methodInfos) {
            Object[] data = new Object[]{methodInfo.getName(), methodInfo.getCount(), methodInfo.getMinDuration(), methodInfo.getMaxDuration(), methodInfo.getAverateDuration()};
            if (this.logLevel == LogLevel.TRACE) {
                this.usageLogger.trace("[{}]: count {}, min {}ms, max {}ms, average {}ms", data);
                continue;
            }
            if (this.logLevel == LogLevel.DEBUG) {
                this.usageLogger.debug("[{}]: count {}, min {}ms, max {}ms, average {}ms", data);
                continue;
            }
            if (this.logLevel == LogLevel.INFO) {
                this.usageLogger.info("[{}]: count {}, min {}ms, max {}ms, average {}ms", data);
                continue;
            }
            if (this.logLevel == LogLevel.WARN) {
                this.usageLogger.warn("[{}]: count {}, min {}ms, max {}ms, average {}ms", data);
                continue;
            }
            if (this.logLevel != LogLevel.ERROR) continue;
            this.usageLogger.error("[{}]: count {}, min {}ms, max {}ms, average {}ms", data);
        }
    }
}

