/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.activemq.jndi.ActiveMQInitialContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheActiveMQInitialContextFactory
extends ActiveMQInitialContextFactory {
    private static final Logger log = LoggerFactory.getLogger(EhcacheActiveMQInitialContextFactory.class);

    public Context getInitialContext(Hashtable environment) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("Environment: {}", (Object)environment);
        }
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        String providerURL = (String)environment.get("java.naming.provider.url");
        String topicFactoryBindingName = (String)environment.get("replicationTopicConnectionFactoryBindingName");
        String topicBindingName = (String)environment.get("replicationTopicBindingName");
        String queueFactoryBindingName = (String)environment.get("getQueueConnectionFactoryBindingName");
        String queueBindingName = (String)environment.get("getQueueBindingName");
        if (log.isDebugEnabled()) {
            log.debug("ProviderURL: {}", (Object)providerURL);
            log.debug("TopicFactoryBindingName: {}", (Object)topicFactoryBindingName);
            log.debug("TopicBindingName: {}", (Object)topicBindingName);
            log.debug("QueueFactoryBindingName: {}", (Object)queueFactoryBindingName);
            log.debug("QueueBindingName: {}", (Object)queueBindingName);
        }
        try {
            if (topicFactoryBindingName != null) {
                data.put(topicFactoryBindingName, this.createConnectionFactory(environment));
            }
        }
        catch (Exception e) {
            log.error("Error creating topic connection factory", (Throwable)e);
            throw new NamingException("Error initialisating topic ConnectionFactory");
        }
        if (topicBindingName != null) {
            data.put(topicBindingName, this.createTopic(topicBindingName));
        }
        try {
            data.put(queueFactoryBindingName, this.createConnectionFactory(environment));
        }
        catch (Exception e) {
            log.error("Error creating queue connection factory", (Throwable)e);
            throw new NamingException("Error initialisating topic ConnectionFactory");
        }
        data.put(queueBindingName, this.createQueue(queueBindingName));
        return this.createContext(environment, data);
    }
}

