/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import si.nevensrok.common.dataimport.AbstractFileReader;

public class OdsFileReader
extends AbstractFileReader {
    private Iterator<Node> nodeIterator;

    @Override
    public void init(InputStream inputStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equalsIgnoreCase("content.xml")) {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document document = docBuilder.parse(zipInputStream);
                Element rootElement = document.getDocumentElement();
                Node bodyNode = this.getSubNodeByName(rootElement, "office:body");
                Node spreadsheetNode = this.getSubNodeByName(bodyNode, "office:spreadsheet");
                Node tableNode = this.getSubNodeByName(spreadsheetNode, "table:table");
                List<Node> tableRowNodes = this.getSubNodesByName(tableNode, "table:table-row");
                this.nodeIterator = tableRowNodes.iterator();
                break;
            }
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String[] readLine() throws Exception {
        ArrayList<String> data;
        boolean emptyLine;
        do {
            if (!this.nodeIterator.hasNext()) {
                return null;
            }
            Node rowNode = this.nodeIterator.next();
            List<Node> cellNodes = this.getSubNodesByName(rowNode, "table:table-cell");
            data = new ArrayList<String>(cellNodes.size());
            int n = 0;
            emptyLine = true;
            for (Node cellNode : cellNodes) {
                Node textNode = this.getSubNodeByName(cellNode, "text:p");
                if (textNode != null) {
                    data.add(textNode.getTextContent());
                    emptyLine = false;
                } else {
                    data.add("");
                }
                Node repeatedAttribute = cellNode.getAttributes().getNamedItem("table:number-columns-repeated");
                if (repeatedAttribute != null) {
                    int repeatCount = Integer.parseInt(repeatedAttribute.getTextContent());
                    for (int i = 1; i < repeatCount; ++i) {
                        data.add((String)data.get(++n - 1));
                    }
                }
                ++n;
            }
        } while (emptyLine);
        return data.toArray(new String[0]);
    }

    private Node getSubNodeByName(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!name.equals(subNode.getNodeName())) continue;
            return subNode;
        }
        return null;
    }

    private Node getSubNodeByName(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!name.equals(subNode.getNodeName())) continue;
            return subNode;
        }
        return null;
    }

    private List<Node> getSubNodesByName(Node node, String name) {
        LinkedList<Node> subNodes = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            if (!name.equals(subNode.getNodeName())) continue;
            subNodes.add(subNode);
        }
        return subNodes;
    }
}

