/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.jms;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.cache.AbstractCacheManager;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.ClearCacheMessage;
import si.nevensrok.common.cache.EvictCacheMessage;
import si.nevensrok.common.cache.PutCacheMessage;
import si.nevensrok.common.cache.jms.JmsCache;
import si.nevensrok.common.utils.ObjectUtil;

public class JmsCacheManager
extends AbstractCacheManager
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JmsCacheManager.class);
    private static final boolean transacted = false;
    private static final int acknowledgeMode = 1;
    private static final int deliveryMode = 1;
    private ConnectionFactory connectionFactory;
    private String topicName;
    private Connection connection;
    private Session session;
    private Topic topic;
    private MessageConsumer messageConsumer;
    private MessageProducer messageProducer;
    private Map<String, JmsCache> cacheStore = new LinkedHashMap<String, JmsCache>();

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' must be specified");
        }
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.topic = this.session.createTopic(this.topicName);
        this.messageConsumer = this.session.createConsumer((Destination)this.topic, null, true);
        this.messageConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    if (message instanceof BytesMessage) {
                        BytesMessage bytesMessage = (BytesMessage)message;
                        byte[] data = new byte[(int)bytesMessage.getBodyLength()];
                        bytesMessage.readBytes(data);
                        Object object = ObjectUtil.deserializeObject(data);
                        log.trace("Cache message received: {}", object);
                        if (object == null) {
                            return;
                        }
                        if (object instanceof PutCacheMessage) {
                            PutCacheMessage putCacheMessage = (PutCacheMessage)object;
                            JmsCache jmsCache = JmsCacheManager.this.getCache(putCacheMessage.getCacheName());
                            jmsCache.addCache(putCacheMessage.getKey(), putCacheMessage.getCachedValue());
                        } else if (object instanceof EvictCacheMessage) {
                            EvictCacheMessage evictMessage = (EvictCacheMessage)object;
                            JmsCache jmsCache = JmsCacheManager.this.getCache(evictMessage.getCacheName());
                            jmsCache.evictCache(evictMessage.getKey());
                        } else if (object instanceof ClearCacheMessage) {
                            ClearCacheMessage clearCacheMessage = (ClearCacheMessage)object;
                            JmsCache jmsCache = JmsCacheManager.this.getCache(clearCacheMessage.getCacheName());
                            jmsCache.clearCache();
                        } else {
                            log.debug("Unsupported message type: {}", (Object)object.getClass().getName());
                        }
                    } else {
                        log.debug("Unsupported jms message type: {}", (Object)message.getClass().getName());
                    }
                }
                catch (Throwable e) {
                    log.error("Error processing message", e);
                }
            }
        });
        this.messageProducer = this.session.createProducer((Destination)this.topic);
        this.messageProducer.setDeliveryMode(1);
    }

    public void destroy() throws Exception {
        try {
            this.messageProducer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.messageConsumer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsCache getCache(String name) {
        JmsCache cache;
        Map<String, JmsCache> map = this.cacheStore;
        synchronized (map) {
            cache = this.cacheStore.get(name);
            if (cache == null) {
                CacheSettings settings = this.getCacheSettings().get(name);
                if (settings == null) {
                    settings = this.getDefaultCacheSettings();
                }
                cache = new JmsCache(name, settings, this.session, this.messageProducer);
                this.cacheStore.put(name, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheNames() {
        Map<String, JmsCache> map = this.cacheStore;
        synchronized (map) {
            return new LinkedList<String>(this.cacheStore.keySet());
        }
    }
}

