-- create table
CREATE TABLE Requests
(
	RequestId bigint NOT NULL IDENTITY,
	MethodId varchar(4096) NOT NULL,
	BeanName varchar(4096),
	RequestDate datetime NOT NULL,
	ThreadName varchar(4096) NOT NULL,
	Duration int NOT NULL,
	WithoutError bit NOT NULL,
	ErrorData text,
	MachineIp4 varchar(15),
	MachineIp6 varchar(45),
	MachineHostname varchar(1024),
	MachineName varchar(100),
	ProcessName varchar(1024),
	PRIMARY KEY (RequestId)
);


CREATE TABLE RequestDatas
(
	RequestId bigint NOT NULL,
	ParameterName varchar(4096) NOT NULL,
	ParameterValue text,
	ParameterClass varchar(4096)
);


CREATE TABLE ResponseDatas
(
	RequestId bigint NOT NULL,
	ParameterName varchar(4096) NOT NULL,
	ParameterValue text,
	ParameterClass varchar(4096)
);


ALTER TABLE ResponseDatas
	ADD FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId)
;


ALTER TABLE RequestDatas
	ADD FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId)
;

--search index
CREATE INDEX SearchIndex1 ON Requests (RequestDate,MethodId,BeanName,WithoutError);

