/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.tcp;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.remoting.tcp.ExecuteMethodMessage;
import si.nevensrok.common.remoting.tcp.MethodExecutedResponse;

public class TcpNetworkProxyFactoryBean
implements FactoryBean<Object>,
MethodInterceptor,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TcpNetworkProxyFactoryBean.class);
    private Object messageIdCountMonitor = new Object();
    private long messageIdCounter = 1L;
    private Class<?> serviceInterface;
    private Object serviceProxy;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private TcpNetworkClient tcpNetworkClient;
    private int connectTimeout = 10000;
    private Object responsesMonitor = new Object();
    private Map<Long, MethodExecutedResponse> responses = new HashMap<Long, MethodExecutedResponse>();
    private boolean active = false;

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setTcpNetworkClient(TcpNetworkClient tcpNetworkClient) {
        this.tcpNetworkClient = tcpNetworkClient;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.tcpNetworkClient == null) {
            throw new IllegalArgumentException("Property 'tcpNetworkClient' is required");
        }
        this.serviceProxy = new ProxyFactory(this.serviceInterface, (Interceptor)this).getProxy(this.beanClassLoader);
        this.active = true;
        Thread thread = new Thread("Response reader thread for " + this.tcpNetworkClient.getAddress() + ":" + this.tcpNetworkClient.getPort()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (TcpNetworkProxyFactoryBean.this.active) {
                        NetworkMessage networkMessage = TcpNetworkProxyFactoryBean.this.tcpNetworkClient.receiveMessage();
                        MethodExecutedResponse methodExecutedResponse = (MethodExecutedResponse)networkMessage.getData();
                        Object object = TcpNetworkProxyFactoryBean.this.responsesMonitor;
                        synchronized (object) {
                            TcpNetworkProxyFactoryBean.this.responses.put(methodExecutedResponse.getMessageId(), methodExecutedResponse);
                            TcpNetworkProxyFactoryBean.this.responsesMonitor.notifyAll();
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    log.trace("Error handling response", (Throwable)e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.active = false;
        Object object = this.responsesMonitor;
        synchronized (object) {
            this.responsesMonitor.notifyAll();
        }
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodExecutedResponse methodExecutedResponse;
        Long messageId;
        Object object = this.messageIdCountMonitor;
        synchronized (object) {
            messageId = this.messageIdCounter++;
        }
        String methodName = invocation.getMethod().getName();
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        Object[] arguments = invocation.getArguments();
        ExecuteMethodMessage executeMethodMessage = new ExecuteMethodMessage();
        executeMethodMessage.setMessageId(messageId);
        executeMethodMessage.setMethodName(methodName);
        executeMethodMessage.setParameterTypes(parameterTypes);
        executeMethodMessage.setArguments(arguments);
        if (!this.tcpNetworkClient.waitForConnection((long)this.connectTimeout)) {
            throw new RuntimeException("Not connected");
        }
        this.tcpNetworkClient.sendMessage((Object)executeMethodMessage);
        Object object2 = this.responsesMonitor;
        synchronized (object2) {
            while (!this.responses.containsKey(messageId) && this.active) {
                this.responsesMonitor.wait();
            }
            methodExecutedResponse = this.responses.remove(messageId);
        }
        if (methodExecutedResponse == null) {
            throw new RuntimeException("Not connected");
        }
        if (methodExecutedResponse.getThrowable() != null) {
            throw methodExecutedResponse.getThrowable();
        }
        return methodExecutedResponse.getResult();
    }

    public boolean isSingleton() {
        return true;
    }
}

