/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

public class RegexUtil {
    public static final String VALID_EMAIL = "[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})";
    public static final String VALID_HOSTNAME = "[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*";
    public static final String VALID_IPV4 = "\\A(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z";
    public static final String VALID_IPV6_FULL = "([0-9A-Fa-f]{1,4})(\\x3A[0-9A-Fa-f]{1,4}){7}";
    public static final String VALID_IPV6 = "(([0-9A-Fa-f]{1,4})(\\x3A[0-9A-Fa-f]{1,4}){7})|(([0-9A-Fa-f]{1,4})(\\x3A{1,2}[0-9A-Fa-f]{1,4}){1,6})";
    public static final String VALID_HTTP = "(https?)://(([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*)|(\\A(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z)|(\\x5B((([0-9A-Fa-f]{1,4})(\\x3A[0-9A-Fa-f]{1,4}){7})|(([0-9A-Fa-f]{1,4})(\\x3A{1,2}[0-9A-Fa-f]{1,4}){1,6}))\\x5D))(\\x3A[0-9]{1,5})?(\\x2F[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*)*";

    public static String escapePattern(String pattern) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            text.append("\\x");
            text.append(Integer.toHexString(c));
        }
        return text.toString();
    }

    public static String createWildcardRegex(String pattern) {
        StringBuilder regex = new StringBuilder();
        boolean startsWithStart = false;
        boolean endsWithStart = false;
        if (pattern.startsWith("*")) {
            startsWithStart = true;
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("*")) {
            endsWithStart = true;
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        String[] parts = pattern.split("\\x2A");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            if (i > 0) {
                regex.append(".*");
                regex.append(RegexUtil.escapePattern(part));
                continue;
            }
            regex.append(RegexUtil.escapePattern(part));
        }
        if (startsWithStart) {
            regex.insert(0, ".*");
        }
        if (endsWithStart) {
            regex.append(".*");
        }
        return regex.toString();
    }
}

