/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.security.MessageDigest;

public class HashUtil {
    public static byte[] generateHash(byte[] data, HashType hashType) {
        try {
            String digestType = null;
            switch (hashType) {
                case MD5: {
                    digestType = "MD5";
                    break;
                }
                case SHA1: {
                    digestType = "SHA-1";
                    break;
                }
                case SHA256: {
                    digestType = "SHA-256";
                }
            }
            MessageDigest messageDigest = MessageDigest.getInstance(digestType);
            byte[] hash = messageDigest.digest(data);
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculation hash", e);
        }
    }

    public static boolean checkHash(byte[] data, HashType hashType, byte[] hash) {
        byte[] calculatedHash = HashUtil.generateHash(data, hashType);
        if (hash.length != calculatedHash.length) {
            return false;
        }
        for (int i = 0; i < calculatedHash.length; ++i) {
            if (calculatedHash[i] == hash[i]) continue;
            return false;
        }
        return true;
    }

    public static enum HashType {
        MD5,
        SHA1,
        SHA256;

    }
}

