/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.textrenderer.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.textrenderer.TextRenderer;
import si.nevensrok.common.textrenderer.velocity.ContextData;
import si.nevensrok.common.textrenderer.velocity.MessageLoader;
import si.nevensrok.common.textrenderer.velocity.ResourceLoaderConfiguration;

public class VelocityTextRenderer
implements TextRenderer,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(VelocityTextRenderer.class);
    private ResourceLoaderConfiguration resourceLoaderConfiguration = null;
    private MessageLoader messageLoader;
    private String prefix = "";
    private String suffix = "";
    private Map<String, Object> toolbox;
    private VelocityEngine velocityEngine;
    private List<String> macroLibraries = new LinkedList<String>();

    public VelocityTextRenderer() {
        this.macroLibraries.add("/si/nevensrok/common/textrenderer/velocity/springMessage.vm");
    }

    public ResourceLoaderConfiguration getResourceLoaderConfiguration() {
        return this.resourceLoaderConfiguration;
    }

    public void setResourceLoaderConfiguration(ResourceLoaderConfiguration resourceLoaderConfiguration) {
        this.resourceLoaderConfiguration = resourceLoaderConfiguration;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public MessageLoader getMessageLoader() {
        return this.messageLoader;
    }

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public Map<String, Object> getToolbox() {
        return this.toolbox;
    }

    public void setToolbox(Map<String, Object> toolbox) {
        this.toolbox = toolbox;
    }

    public void afterPropertiesSet() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Initializing velocity engine");
        }
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
        this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)this.resourceLoaderConfiguration.getResourceLoaderClassname());
        if (this.resourceLoaderConfiguration.getConfiguration() != null) {
            for (String key : this.resourceLoaderConfiguration.getConfiguration().keySet()) {
                String value = this.resourceLoaderConfiguration.getConfiguration().get(key);
                if (log.isDebugEnabled()) {
                    log.debug("Adding velocity property: {}={}", (Object)key, (Object)value);
                }
                this.velocityEngine.setProperty("classpath.resource.loader." + key, (Object)value);
            }
        }
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"si.nevensrok.common.textrenderer.velocity.VelocityLogger");
        this.velocityEngine.init();
        if (log.isDebugEnabled()) {
            log.debug("Velocity engine initialized");
        }
    }

    @Override
    public String renderText(String file, Map<String, Object> data) {
        return this.renderText(file, data, null);
    }

    @Override
    public String renderText(String file, Map<String, Object> data, Locale locale) {
        String templateFilePath = this.prefix + file + this.suffix;
        if (log.isDebugEnabled()) {
            log.debug("Using template: {}", (Object)templateFilePath);
        }
        Template template = this.velocityEngine.getTemplate(templateFilePath);
        VelocityContext context = new VelocityContext();
        for (String string : data.keySet()) {
            context.put(string, data.get(string));
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ContextData contextData = new ContextData();
        contextData.setLocale(locale);
        contextData.setMessageLoader(this.messageLoader);
        context.put("contextData", (Object)contextData);
        if (this.toolbox != null) {
            for (String key : this.toolbox.keySet()) {
                Object tool = this.toolbox.get(key);
                context.put(key, tool);
            }
        }
        StringWriter stringWriter = new StringWriter();
        template.merge((Context)context, (Writer)stringWriter, this.macroLibraries);
        return stringWriter.toString();
    }
}

