/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl.certificate;

import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class ResourceCertificateLoader
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String factoryName = "X.509";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public Certificate loadCertificate(String location) {
        try {
            Resource resource = this.applicationContext.getResource(location);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(this.factoryName);
            Certificate certificate = certificateFactory.generateCertificate(resource.getInputStream());
            return certificate;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading certificate from resource " + location, e);
        }
    }
}

