/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.InetAddress;
import java.net.MulticastSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageReceiver;
import si.nevensrok.common.network.udp.MessageReceiver;

public class MulticastMessagesReceiver
implements NetworkMessageReceiver,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MulticastMessagesReceiver.class);
    private String address;
    private Integer port;
    private int bufferSize = 65536;
    private MulticastSocket socket = null;
    private MessageReceiver messageReceiver;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.address == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        if (log.isDebugEnabled()) {
            log.debug("Connecting to multicast on {}:{}", (Object)this.address, (Object)this.port);
        }
        try {
            this.socket = new MulticastSocket(this.port);
            this.socket.joinGroup(InetAddress.getByName(this.address));
            this.messageReceiver = new MessageReceiver(this.socket, this.bufferSize);
        }
        catch (Exception e) {
            try {
                this.messageReceiver.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to broadcast", e);
        }
    }

    public void destroy() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from multicast on {}:{}", (Object)this.address, (Object)this.port);
        }
        try {
            this.messageReceiver.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.leaveGroup(InetAddress.getByName(this.address));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public NetworkMessage receiveMessage() throws NetworkException {
        return this.messageReceiver.getNextMessage();
    }
}

