/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.streams;

import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;

public class EncryptedOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private Cipher cipher;
    private boolean closed = false;
    private byte[] buffer = new byte[16384];
    private int bufferPos = 0;

    public EncryptedOutputStream(OutputStream outputStream, Cipher cipher) {
        this.outputStream = outputStream;
        this.cipher = cipher;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.buffer[this.bufferPos] = (byte)b;
        ++this.bufferPos;
        if (this.bufferPos >= this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.bufferPos == 0) {
            return;
        }
        byte[] data = new byte[this.bufferPos];
        System.arraycopy(this.buffer, 0, data, 0, this.bufferPos);
        this.bufferPos = 0;
        try {
            data = this.cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IOException("Error encrypting data", e);
        }
        int n1 = data.length;
        int n2 = data.length >> 8 & 0xFF;
        this.outputStream.write(n1);
        this.outputStream.write(n2);
        this.outputStream.write(data);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        this.outputStream.close();
    }
}

