/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.tcp;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CachePeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.tcp.TcpMessageHandler;
import si.nevensrok.common.network.tcp.TcpNetworkClient;

public class TcpCachePeer
implements CachePeer {
    private static final Logger log = LoggerFactory.getLogger(TcpCachePeer.class);
    private CacheManager cacheManager;
    private TcpNetworkClient tcpNetworkClient;
    private TcpMessageHandler tcpMessageHandler;

    public TcpCachePeer(CacheManager cacheManager, TcpNetworkClient tcpNetworkClient) {
        this.cacheManager = cacheManager;
        this.tcpNetworkClient = tcpNetworkClient;
        this.tcpMessageHandler = new TcpMessageHandler(cacheManager, tcpNetworkClient);
    }

    public void close() {
        this.tcpMessageHandler.close();
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public boolean remove(Serializable key) throws IllegalStateException, RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public void removeAll() throws RemoteException, IllegalStateException {
        throw new RemoteException("Not implemented for TCP");
    }

    public void send(List eventMessages) throws RemoteException {
        try {
            for (Object eventMessage : eventMessages) {
                this.tcpNetworkClient.sendMessage(eventMessage);
            }
        }
        catch (Exception e) {
            log.error("Error sending event messages", (Throwable)e);
        }
    }

    public String getName() throws RemoteException {
        return this.cacheManager.getName() + " TCPCachePeer";
    }

    public String getGuid() throws RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public String getUrl() throws RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public String getUrlBase() throws RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public List getKeys() throws RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public Element getQuiet(Serializable key) throws RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }

    public List getElements(List keys) throws RemoteException {
        throw new RemoteException("Not implemented for TCP");
    }
}

