/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.distributed;

import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.util.ClassUtils;
import si.nevensrok.common.remoting.distributed.ServiceInfo;

public class DistributedService
implements FactoryBean<Object>,
MethodInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DistributedService.class);
    private Object serviceProxy;
    private Class<?> serviceInterface;
    private long[] failTimeouts = new long[]{10000L};
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object[] serviceList;
    private ServiceInfo[] services;
    private int serviceIndex = 0;

    public void setServiceList(Object[] serviceList) {
        this.serviceList = serviceList;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setFailTimeouts(long[] failTimeouts) {
        this.failTimeouts = failTimeouts;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.failTimeouts == null) {
            throw new IllegalArgumentException("Property 'failTimeouts' is required");
        }
        if (this.failTimeouts.length == 0) {
            throw new IllegalArgumentException("FailTimeouts is empty");
        }
        if (this.serviceList == null) {
            throw new IllegalArgumentException("Property 'serviceList' is required");
        }
        if (this.serviceList.length == 0) {
            throw new IllegalArgumentException("ServiceList is empty");
        }
        this.serviceProxy = new ProxyFactory(this.serviceInterface, (Interceptor)this).getProxy(this.beanClassLoader);
        this.services = new ServiceInfo[this.serviceList.length];
        int i = 0;
        for (Object service : this.serviceList) {
            if (!this.serviceInterface.isAssignableFrom(service.getClass())) {
                throw new IllegalArgumentException("Class " + service.getClass().getName() + " does not implements " + this.serviceInterface.getName());
            }
            this.services[i++] = new ServiceInfo(this.serviceInterface, service, this.failTimeouts);
        }
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    private synchronized ServiceInfo getNextService() {
        for (int i = 0; i < this.services.length; ++i) {
            ServiceInfo serviceInfo = this.services[this.serviceIndex];
            this.serviceIndex = (this.serviceIndex + 1) % this.services.length;
            if (serviceInfo.getNextAttemptTime() > 0L) {
                if (serviceInfo.getNextAttemptTime() > System.currentTimeMillis()) continue;
                serviceInfo.addAttemptFailure();
            }
            return serviceInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        for (int i = 0; i < this.services.length; ++i) {
            DistributedService distributedService;
            ServiceInfo serviceInfo = this.getNextService();
            if (serviceInfo == null) {
                throw new IllegalAccessException("No available services found");
            }
            try {
                Object value = serviceInfo.execute(invocation.getMethod(), invocation.getArguments());
                distributedService = this;
                synchronized (distributedService) {
                    serviceInfo.resetFailAttempts();
                }
                return value;
            }
            catch (IllegalAccessException e) {
                log.debug("Error while executing method", (Throwable)e);
                distributedService = this;
                synchronized (distributedService) {
                    serviceInfo.addAttemptFailure();
                    continue;
                }
            }
            catch (IllegalArgumentException e) {
                log.debug("Error while executing method", (Throwable)e);
                distributedService = this;
                synchronized (distributedService) {
                    serviceInfo.addAttemptFailure();
                    continue;
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RemoteAccessException) {
                    log.debug("Error while executing method", e.getCause());
                    distributedService = this;
                    synchronized (distributedService) {
                        serviceInfo.addAttemptFailure();
                        continue;
                    }
                }
                distributedService = this;
                synchronized (distributedService) {
                    serviceInfo.resetFailAttempts();
                }
                throw e.getCause();
            }
            catch (Throwable e) {
                log.debug("Error while executing method", e);
                distributedService = this;
                synchronized (distributedService) {
                    serviceInfo.addAttemptFailure();
                    continue;
                }
            }
        }
        throw new IllegalAccessException("No available services found");
    }
}

