/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import si.nevensrok.common.hazelcast.HazelcastBroadcastDiscoverer;
import si.nevensrok.common.hazelcast.HazelcastBroadcastReplier;

public class HazelcastInstanceFactory
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HazelcastInstanceFactory.class);
    private List<HazelcastInstance> hazelcastInstances = new LinkedList<HazelcastInstance>();
    private Resource xmlConfigurationResource = null;
    private String multicastGroup = null;
    private Integer multicastPort = null;
    private String[] tcpAddresses = null;
    private int port = 5701;
    private boolean portAutoIncrement = true;
    private int portCount = 100;
    private int portTryCount = 3;
    private int connectionTimeoutSeconds = 5;
    private String groupName = null;
    private String groupPassword = null;
    private Map<String, Integer> executorPoolSizes = null;
    private String broadcastDomain = null;
    private int broadcastPort = 5801;
    private int broadcastPortCount = 100;
    private int broadcastPortTryCount = 3;
    private int broadcastReplyWaitTime = 2000;
    private String[] interfaces = null;
    private HazelcastBroadcastReplier hazelcastBroadcastReplier = null;

    public void setXmlConfigurationResource(Resource xmlConfigurationResource) {
        this.xmlConfigurationResource = xmlConfigurationResource;
    }

    public Resource getXmlConfigurationResource() {
        return this.xmlConfigurationResource;
    }

    public void setMulticastGroup(String multicastGroup) {
        this.multicastGroup = multicastGroup;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public void setMulticastPort(Integer multicastPort) {
        this.multicastPort = multicastPort;
    }

    public Integer getMulticastPort() {
        return this.multicastPort;
    }

    public void setTcpAddresses(String[] tcpAddresses) {
        this.tcpAddresses = tcpAddresses;
    }

    public String[] getTcpAddresses() {
        return this.tcpAddresses;
    }

    public void setTcpAddress(String tcpAddress) {
        this.tcpAddresses = new String[]{tcpAddress};
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
    }

    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    public void setPortCount(int portCount) {
        this.portCount = portCount;
    }

    public int getPortCount() {
        return this.portCount;
    }

    public void setPortTryCount(int portTryCount) {
        this.portTryCount = portTryCount;
    }

    public int getPortTryCount() {
        return this.portTryCount;
    }

    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public void setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupPassword() {
        return this.groupPassword;
    }

    public void setGroupPassword(String groupPassword) {
        this.groupPassword = groupPassword;
    }

    public void setExecutorPoolSizes(Map<String, Integer> executorPoolSizes) {
        this.executorPoolSizes = executorPoolSizes;
    }

    public Map<String, Integer> getExecutorPoolSizes() {
        return this.executorPoolSizes;
    }

    public void setBroadcastDomain(String broadcastDomain) {
        this.broadcastDomain = broadcastDomain;
    }

    public String getBroadcastDomain() {
        return this.broadcastDomain;
    }

    public void setBroadcastPort(int broadcastPort) {
        this.broadcastPort = broadcastPort;
    }

    public int getBroadcastPort() {
        return this.broadcastPort;
    }

    public void setBroadcastPortCount(int broadcastPortCount) {
        this.broadcastPortCount = broadcastPortCount;
    }

    public int getBroadcastPortCount() {
        return this.broadcastPortCount;
    }

    public void setBroadcastPortTryCount(int broadcastPortTryCount) {
        this.broadcastPortTryCount = broadcastPortTryCount;
    }

    public int getBroadcastPortTryCount() {
        return this.broadcastPortTryCount;
    }

    public void setBroadcastReplyWaitTime(int broadcastReplyWaitTime) {
        this.broadcastReplyWaitTime = broadcastReplyWaitTime;
    }

    public int getBroadcastReplyWaitTime() {
        return this.broadcastReplyWaitTime;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setInterfacesAsString(String interfaces) {
        this.interfaces = interfaces.split("[,;]");
    }

    public void afterPropertiesSet() throws Exception {
        if (this.xmlConfigurationResource == null && (this.multicastGroup == null || this.multicastPort == null) && this.tcpAddresses == null && this.broadcastDomain == null) {
            throw new IllegalArgumentException("Property 'xmlConfigurationResource' or 'multicastGroup' and 'multicastPort' or 'tcpAddresses' or 'broadcastDomain' must be specified");
        }
        if (this.interfaces != null && this.interfaces.length == 0) {
            this.interfaces = null;
        }
        if (this.broadcastDomain != null) {
            this.hazelcastBroadcastReplier = new HazelcastBroadcastReplier(this.hazelcastInstances, this.broadcastDomain, this.broadcastPort, this.broadcastPortCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.hazelcastBroadcastReplier != null) {
            this.hazelcastBroadcastReplier.close();
            this.hazelcastBroadcastReplier = null;
        }
        List<HazelcastInstance> list = this.hazelcastInstances;
        synchronized (list) {
            for (HazelcastInstance hazelcastInstance : this.hazelcastInstances) {
                hazelcastInstance.shutdown();
            }
            this.hazelcastInstances.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HazelcastInstance generateHazelcastInstance() throws IOException {
        Config config;
        String[] members;
        if (this.broadcastDomain != null) {
            try {
                HazelcastBroadcastDiscoverer hazelcastBroadcastDiscoverer = new HazelcastBroadcastDiscoverer(this.broadcastDomain, this.broadcastPort, this.broadcastPortTryCount, this.interfaces);
                Thread.sleep(this.broadcastReplyWaitTime);
                members = hazelcastBroadcastDiscoverer.getMembers();
                String[] stringArray = members;
                // MONITORENTER : members
                this.tcpAddresses = members.toArray(new String[members.size()]);
                // MONITOREXIT : stringArray
                hazelcastBroadcastDiscoverer.close();
            }
            catch (Exception e) {
                log.error("Error halecast discovery via broadcast", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Discovered members via broadcast: {}", new Object[]{this.tcpAddresses});
            }
        }
        if (this.xmlConfigurationResource != null) {
            config = new XmlConfigBuilder(this.xmlConfigurationResource.getInputStream()).build();
        } else {
            config = new Config();
            config.setProperty("hazelcast.logging.type", "slf4j");
            config.setProperty("hazelcast.tcp.join.port.try.count", String.valueOf(this.portTryCount));
            config.setNetworkConfig(new NetworkConfig());
            config.getNetworkConfig().setPort(this.port);
            config.getNetworkConfig().setPortAutoIncrement(this.portAutoIncrement);
            config.getNetworkConfig().setPortCount(this.portCount);
            if (this.interfaces != null) {
                config.getNetworkConfig().setInterfaces(new InterfacesConfig());
                config.getNetworkConfig().getInterfaces().setEnabled(true);
                members = this.interfaces;
                int n = members.length;
                for (int i = 0; i < n; ++i) {
                    String device = members[i];
                    for (String ip : HazelcastInstanceFactory.getIpListForDevice(device)) {
                        config.getNetworkConfig().getInterfaces().addInterface(ip);
                    }
                }
            }
            if (this.groupName != null || this.groupPassword != null) {
                config.setGroupConfig(new GroupConfig());
                if (this.groupName != null) {
                    config.getGroupConfig().setName(this.groupName);
                }
                if (this.groupPassword != null) {
                    config.getGroupConfig().setPassword(this.groupPassword);
                }
            }
            if (this.executorPoolSizes != null) {
                String[] executorConfigs = new LinkedHashMap();
                for (Map.Entry entry : this.executorPoolSizes.entrySet()) {
                    ExecutorConfig executorConfig = new ExecutorConfig((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
                    executorConfigs.put(entry.getKey(), executorConfig);
                }
                config.setExecutorConfigs(executorConfigs);
            }
            config.getNetworkConfig().setJoin(new JoinConfig());
            config.getNetworkConfig().getJoin().setMulticastConfig(new MulticastConfig());
            config.getNetworkConfig().getJoin().setTcpIpConfig(new TcpIpConfig());
            if (this.multicastGroup != null && this.multicastPort != null) {
                config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
                config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
                config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(this.multicastGroup);
                config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(this.multicastPort.intValue());
            } else if (this.broadcastDomain != null || this.tcpAddresses != null) {
                config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
                config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
                config.getNetworkConfig().getJoin().getTcpIpConfig().setConnectionTimeoutSeconds(this.connectionTimeoutSeconds);
                for (String tcpAddress : this.tcpAddresses) {
                    config.getNetworkConfig().getJoin().getTcpIpConfig().addMember(tcpAddress);
                }
            }
        }
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        List<HazelcastInstance> list = this.hazelcastInstances;
        // MONITORENTER : list
        this.hazelcastInstances.add(hazelcastInstance);
        // MONITOREXIT : list
        return hazelcastInstance;
    }

    private static List<String> getIpListForDevice(String device) {
        LinkedList<String> ipList = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                NetworkInterface networkInterface = i.nextElement();
                if (!networkInterface.getName().equalsIgnoreCase(device) && !HazelcastInstanceFactory.hasDeviceIpAddress(networkInterface, device)) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (interfaceAddress.getAddress() == null) continue;
                    ipList.add(interfaceAddress.getAddress().getHostAddress());
                }
            }
        }
        catch (Exception e) {
            log.error("Error retriving ip list for network device: " + device, (Throwable)e);
        }
        return ipList;
    }

    private static boolean hasDeviceIpAddress(NetworkInterface networkInterface, String ipAddress) {
        for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
            if (interfaceAddress.getAddress() == null || !ipAddress.equalsIgnoreCase(interfaceAddress.getAddress().getHostAddress())) continue;
            return true;
        }
        return false;
    }
}

