/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.geolocation.google;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.geolocation.Address;
import si.nevensrok.common.geolocation.AddressGeoLocator;
import si.nevensrok.common.geolocation.GeoCoordinates;
import si.nevensrok.common.geolocation.google.GoogleResult;

public class GoogleAddressGeoLocator
implements AddressGeoLocator {
    private static final Logger log = LoggerFactory.getLogger(GoogleAddressGeoLocator.class);
    private String apiKey = null;

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public GeoCoordinates findGeoCoordinates(Address address) {
        HttpURLConnection httpURLConnection = null;
        try {
            String addressString = address.getStreet() + " " + address.getStreetNumber() + ", " + address.getPostalCode().toString() + " " + address.getPostName();
            URL url = new URL("https://maps.googleapis.com/maps/api/geocode/json?address=" + URLEncoder.encode(addressString, "UTF-8") + "&sensor=false&key=" + URLEncoder.encode(this.apiKey, "UTF-8"));
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.connect();
            int responseCode = httpURLConnection.getResponseCode();
            String responseMessage = httpURLConnection.getResponseMessage();
            if (log.isTraceEnabled()) {
                log.trace("Response status {}: {}", (Object)responseCode, (Object)responseMessage);
            }
            if (responseCode != 200) {
                throw new RuntimeException("Invalid server response " + responseCode + ": " + responseMessage);
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            GoogleResult result = (GoogleResult)mapper.readValue(inputStream, GoogleResult.class);
            if (log.isTraceEnabled()) {
                log.trace("Result data: {}", (Object)result);
            }
            httpURLConnection.disconnect();
            if (result.getResults().isEmpty()) {
                throw new RuntimeException("Search for coordinates returned no results");
            }
            if (result.getResults().size() > 1) {
                log.warn("Search for coordinates returned multiple results. Using first one");
            }
            GeoCoordinates geoCoordinates = new GeoCoordinates();
            geoCoordinates.setLatitude(result.getResults().get(0).getGeometry().getLocation().getLat());
            geoCoordinates.setLongitude(result.getResults().get(0).getGeometry().getLocation().getLng());
            return geoCoordinates;
        }
        catch (Exception e) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Error while fetching geo locations", (Throwable)e);
            return null;
        }
    }
}

