/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitorType;

public class DuoPoints
implements Serializable {
    private static final long serialVersionUID = -5182855531663415914L;
    private float[][] points1 = new float[5][5];
    private float[][] points2 = new float[5][5];

    public float getPoints1(int round, int judge) {
        return this.points1[round - 1][judge - 1];
    }

    public void setPoints1(int round, int judge, float points) {
        this.points1[round - 1][judge - 1] = points;
    }

    public float getPoints2(int round, int judge) {
        return this.points2[round - 1][judge - 1];
    }

    public void setPoints2(int round, int judge, float points) {
        this.points2[round - 1][judge - 1] = points;
    }

    public float getSum1() {
        float sum = 0.0f;
        for (int round = 1; round <= 5; ++round) {
            for (int judge = 1; judge <= 5; ++judge) {
                sum += this.points1[round - 1][judge - 1];
            }
        }
        return sum;
    }

    public float getSum2() {
        float sum = 0.0f;
        for (int round = 1; round <= 5; ++round) {
            for (int judge = 1; judge <= 5; ++judge) {
                sum += this.points2[round - 1][judge - 1];
            }
        }
        return sum;
    }

    public Set<MatchPoint> getMatchPoints() {
        HashSet<MatchPoint> matchPoints = new HashSet<MatchPoint>();
        for (int round = 1; round <= 5; ++round) {
            for (int judge = 1; judge <= 5; ++judge) {
                MatchPoint matchPoint = new MatchPoint();
                matchPoints.add(matchPoint);
                matchPoint.setCompetitor(CompetitorType.COMPETITOR1);
                matchPoint.setPointType(PointType.JUDGE);
                matchPoint.setRound(Integer.valueOf(round));
                matchPoint.setJudge(Integer.valueOf(judge));
                matchPoint.setPoints(Float.valueOf(this.getPoints1(round, judge)));
                matchPoint = new MatchPoint();
                matchPoints.add(matchPoint);
                matchPoint.setCompetitor(CompetitorType.COMPETITOR2);
                matchPoint.setPointType(PointType.JUDGE);
                matchPoint.setRound(Integer.valueOf(round));
                matchPoint.setJudge(Integer.valueOf(judge));
                matchPoint.setPoints(Float.valueOf(this.getPoints2(round, judge)));
            }
        }
        return matchPoints;
    }

    public void setMatchPoints(Set<MatchPoint> matchPoints) {
        for (MatchPoint matchPoint : matchPoints) {
            if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                this.setPoints1(matchPoint.getRound(), matchPoint.getJudge(), matchPoint.getPoints().floatValue());
                continue;
            }
            if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
            this.setPoints2(matchPoint.getRound(), matchPoint.getJudge(), matchPoint.getPoints().floatValue());
        }
    }

    public String toString() {
        return "DuoPoints [points1=" + Arrays.toString((Object[])this.points1) + ", points2=" + Arrays.toString((Object[])this.points2) + "]";
    }
}

