/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.rules.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.rules.CompetitionRules;

public class RulesManagerImpl
implements RulesManager,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(RulesManagerImpl.class);
    private Map<String, CompetitionRules> rules = new HashMap<String, CompetitionRules>();
    private List<String> availableCompetitionRules = new ArrayList<String>();

    public List<String> getAvailableCompetitionRules() {
        return new ArrayList<String>(this.availableCompetitionRules);
    }

    public CompetitionRules getCompetitionRules(String name) {
        return this.rules.get(name);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        CompetitionRules competitionRules;
        if (bean instanceof CompetitionRules && (competitionRules = (CompetitionRules)bean).getName() != null) {
            if (log.isInfoEnabled()) {
                log.info("Competition rules bean with name {} found {}", (Object)competitionRules.getName(), (Object)competitionRules);
            }
            this.rules.put(competitionRules.getName(), competitionRules);
            this.availableCompetitionRules.add(competitionRules.getName());
        }
        Collections.sort(this.availableCompetitionRules, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        return bean;
    }
}

