/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.x509cert.CertificateUtil;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class KeystoreKeyManager
extends X509ExtendedKeyManager {
    private static final Logger log = LoggerFactory.getLogger(KeystoreKeyManager.class);
    private KeyStore keyStore;
    private char[] password;

    public KeystoreKeyManager(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        this.password = password.toCharArray();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            LinkedList<X509Certificate> chain = new LinkedList<X509Certificate>();
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
            while (cert != null) {
                chain.add(cert);
                cert = this.getIssuer((X509CertImpl)cert);
            }
            log.trace("Chain size: {}", (Object)chain.size());
            return chain.toArray(new X509Certificate[0]);
        }
        catch (Exception e) {
            log.error("Error loading certificate chain", (Throwable)e);
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            if (!this.keyStore.isKeyEntry(alias)) {
                return null;
            }
            Key key = this.keyStore.getKey(alias, this.password);
            return (PrivateKey)key;
        }
        catch (Exception e) {
            log.error("Error loading key", (Throwable)e);
            return null;
        }
    }

    private String[] getAliases(String keyType, Principal[] issuers) {
        try {
            LinkedList<String> aliases = new LinkedList<String>();
            Enumeration<String> aliasEnumeration = this.keyStore.aliases();
            block2: while (aliasEnumeration.hasMoreElements()) {
                Key key;
                String alias = aliasEnumeration.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || !((key = this.keyStore.getKey(alias, this.password)) instanceof RSAPrivateKey) && !(key instanceof DSAPrivateKey)) continue;
                if (issuers == null || issuers.length == 0) {
                    aliases.add(alias);
                    continue;
                }
                X509Certificate[] chain = this.getCertificateChain(alias);
                for (Principal principal : issuers) {
                    if (!this.isUsedBy(chain[chain.length - 1], principal) || !this.isChainValid(chain)) continue;
                    aliases.add(alias);
                    continue block2;
                }
            }
            return aliases.toArray(new String[0]);
        }
        catch (Exception e) {
            log.error("Error getting aliases", (Throwable)e);
            return null;
        }
    }

    private String chooseAlias(String[] keyType, Principal[] issuers) {
        try {
            Enumeration<String> aliasEnumeration = this.keyStore.aliases();
            while (aliasEnumeration.hasMoreElements()) {
                Key key;
                String alias = aliasEnumeration.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || !((key = this.keyStore.getKey(alias, this.password)) instanceof RSAPrivateKey) && !(key instanceof DSAPrivateKey)) continue;
                if (issuers == null || issuers.length == 0) {
                    return alias;
                }
                X509Certificate[] chain = this.getCertificateChain(alias);
                for (Principal principal : issuers) {
                    if (!this.isUsedBy(chain[chain.length - 1], principal) || !this.isChainValid(chain)) continue;
                    return alias;
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error getting aliases", (Throwable)e);
            return null;
        }
    }

    private String chooseAlias(String keyType, Principal[] issuers) {
        try {
            Enumeration<String> aliasEnumeration = this.keyStore.aliases();
            while (aliasEnumeration.hasMoreElements()) {
                Key key;
                String alias = aliasEnumeration.nextElement();
                if (!this.keyStore.isKeyEntry(alias) || !((key = this.keyStore.getKey(alias, this.password)) instanceof RSAPrivateKey) && !(key instanceof DSAPrivateKey)) continue;
                if (issuers == null || issuers.length == 0) {
                    return alias;
                }
                X509Certificate[] chain = this.getCertificateChain(alias);
                for (Principal principal : issuers) {
                    if (!this.isUsedBy(chain[chain.length - 1], principal) || !this.isChainValid(chain)) continue;
                    return alias;
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error getting aliases", (Throwable)e);
            return null;
        }
    }

    private boolean isUsedBy(X509Certificate certificate, Principal principal) {
        try {
            X509CertImpl certImpl = (X509CertImpl)certificate;
            X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
            CertificateIssuerName issuer = (CertificateIssuerName)certInfo.get("issuer");
            return issuer.getName().equals(principal.getName());
        }
        catch (Exception e) {
            log.trace("Error checking issuer name", (Throwable)e);
            return false;
        }
    }

    private boolean isChainValid(X509Certificate[] chain) {
        try {
            for (X509Certificate certificate : chain) {
                certificate.checkValidity();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private X509Certificate getIssuer(X509CertImpl certificate) throws Exception {
        X500Name issuerName;
        X500Name certificateName;
        X509CertInfo certInfo = (X509CertInfo)certificate.get("x509.info");
        if (certInfo.get("subject") instanceof X500Name) {
            certificateName = (X500Name)certInfo.get("subject");
        } else {
            CertificateSubjectName certificateSubjectName = (CertificateSubjectName)certInfo.get("subject");
            certificateName = (X500Name)certificateSubjectName.get("dname");
        }
        if (certInfo.get("issuer") instanceof X500Name) {
            issuerName = (X500Name)certInfo.get("issuer");
        } else {
            CertificateIssuerName issuer = (CertificateIssuerName)certInfo.get("issuer");
            issuerName = (X500Name)issuer.get("dname");
        }
        Enumeration<String> aliasEnumeration = this.keyStore.aliases();
        while (aliasEnumeration.hasMoreElements()) {
            X500Name candidateName;
            String alias = aliasEnumeration.nextElement();
            X509CertImpl candidate = (X509CertImpl)this.keyStore.getCertificate(alias);
            X509CertInfo candidateCertInfo = (X509CertInfo)candidate.get("x509.info");
            if (candidateCertInfo.get("subject") instanceof X500Name) {
                candidateName = (X500Name)candidateCertInfo.get("subject");
            } else {
                CertificateSubjectName candidateSubjectName = (CertificateSubjectName)candidateCertInfo.get("subject");
                candidateName = (X500Name)candidateSubjectName.get("dname");
            }
            if (CertificateUtil.isNameEqual(certificateName, candidateName) || !CertificateUtil.isNameEqual(issuerName, candidateName)) continue;
            return candidate;
        }
        return null;
    }
}

