/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.fw;

import com.hazelcast.core.HazelcastInstance;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import si.nevensrok.common.hazelcast.HazelcastInstanceFactory;
import si.nevensrok.common.remoting.hazelcast.HazelcastServiceProxyFactoryBean;
import si.nevensrok.common.remoting.hazelcast.ServiceRepository;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.services.SemaphoreService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class SemaphoreServiceClient
implements SemaphoreService,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SemaphoreServiceClient.class);
    private AbstractRefreshableApplicationContext applicationContext;
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor;
    private SemaphoreService semaphoreService = null;
    private List<DisposableBean> beansToClose = new LinkedList<DisposableBean>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (AbstractRefreshableApplicationContext)applicationContext;
    }

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public void destroy() throws Exception {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.semaphoreService = null;
    }

    public void setup(String url) {
        for (DisposableBean disposableBean : this.beansToClose) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.beansToClose.clear();
        this.semaphoreService = null;
        if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
            if (log.isDebugEnabled()) {
                log.debug("Setting up HTTP invoker");
            }
            HttpInvokerProxyFactoryBean factoryBean = new HttpInvokerProxyFactoryBean();
            factoryBean.setServiceUrl(url + "/SemaphoreService");
            factoryBean.setServiceInterface(SemaphoreService.class);
            factoryBean.setHttpInvokerRequestExecutor(this.httpInvokerRequestExecutor);
            factoryBean.afterPropertiesSet();
            this.semaphoreService = (SemaphoreService)factoryBean.getObject();
        } else if (url.toLowerCase().startsWith("hc://")) {
            try {
                log.debug("Setting up hazelcast invoker");
                URI uri = new URI(url);
                String broadcastDomain = uri.getHost();
                HazelcastInstanceFactory hazelcastInstanceFactory = new HazelcastInstanceFactory();
                this.beansToClose.add((DisposableBean)hazelcastInstanceFactory);
                hazelcastInstanceFactory.setPort(Integer.parseInt(this.applicationContext.getBeanFactory().resolveEmbeddedValue("${jtekma.hazelcast.remoting.port}")));
                hazelcastInstanceFactory.setPortTryCount(5);
                hazelcastInstanceFactory.setBroadcastDomain(broadcastDomain);
                hazelcastInstanceFactory.setBroadcastPort(Integer.parseInt(this.applicationContext.getBeanFactory().resolveEmbeddedValue("${jtekma.hazelcast.remoting.port}")));
                hazelcastInstanceFactory.setBroadcastPortTryCount(5);
                HazelcastInstance hazelcastInstance = hazelcastInstanceFactory.generateHazelcastInstance();
                ServiceRepository serviceRepository = new ServiceRepository();
                this.beansToClose.add((DisposableBean)serviceRepository);
                serviceRepository.setHazelcastInstance(hazelcastInstance);
                serviceRepository.afterPropertiesSet();
                HazelcastServiceProxyFactoryBean factoryBean = new HazelcastServiceProxyFactoryBean();
                factoryBean.setServiceRepository(serviceRepository);
                factoryBean.setServiceInterface(SemaphoreService.class);
                factoryBean.setVersion("1");
                factoryBean.afterPropertiesSet();
                this.semaphoreService = (SemaphoreService)factoryBean.getObject();
            }
            catch (Exception e) {
                log.error("Error conneting to hazelcast", e);
            }
        } else {
            throw new RuntimeException("Unsupported protocol for URL " + url);
        }
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        if (this.semaphoreService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.semaphoreService.checkLogin(credentials);
    }

    public TatamiFightData getTatamiFightData(Credentials credentials) throws ServiceException {
        if (this.semaphoreService == null) {
            throw new RuntimeException("Not connected");
        }
        return this.semaphoreService.getTatamiFightData(credentials);
    }
}

