/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkServer;
import si.nevensrok.common.ssl.SslContextGenerator;

public class SslTcpNetworkServer
extends TcpNetworkServer {
    private SSLContext sslContext;
    private SslContextGenerator sslContextGenerator;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setSslContextGenerator(SslContextGenerator sslContextGenerator) {
        this.sslContextGenerator = sslContextGenerator;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.sslContext == null && this.sslContextGenerator == null) {
            throw new IllegalArgumentException("Property 'sslContext' or 'sslContextGenerator' is required");
        }
        super.afterPropertiesSet();
    }

    @Override
    protected ServerSocket openSocket() throws Exception {
        SSLServerSocketFactory sslServersocketFactory = null;
        if (this.sslContext != null) {
            sslServersocketFactory = this.sslContext.getServerSocketFactory();
        } else if (this.sslContextGenerator != null) {
            sslServersocketFactory = this.sslContextGenerator.generateSSLContext().getServerSocketFactory();
        }
        SSLServerSocket sslServerSocket = (SSLServerSocket)sslServersocketFactory.createServerSocket(this.getPort());
        if (this.needClientAuth) {
            sslServerSocket.setNeedClientAuth(true);
        }
        if (this.wantClientAuth) {
            sslServerSocket.setWantClientAuth(true);
        }
        return sslServerSocket;
    }

    @Override
    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        SSLSocket sslSocket = (SSLSocket)socket;
        if (this.needClientAuth) {
            sslSocket.setNeedClientAuth(true);
        }
        if (this.wantClientAuth) {
            sslSocket.setWantClientAuth(true);
        }
        return new TcpNetworkConnection(sslSocket);
    }
}

