/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.encryption;

import java.nio.charset.Charset;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.encryption.AesKeyGenerator;
import si.nevensrok.common.encryption.Decryptor;
import si.nevensrok.common.encryption.Encryptor;
import si.nevensrok.common.utils.HashUtil;

public class AesEncryptorDecryptor
implements Encryptor,
Decryptor,
InitializingBean {
    private SecretKey secretKey;
    private byte[] key = null;
    private int keySize = 16;
    private String chipperInstance = "AES/ECB/PKCS5Padding";

    public void setKey(byte[] key) {
        this.key = key;
    }

    public void setKeyAsString(String key) {
        this.key = HashUtil.generateHash(key.getBytes(Charset.forName("UTF8")), HashUtil.HashType.SHA256);
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public void setChipperInstance(String chipperInstance) {
        this.chipperInstance = chipperInstance;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.key == null) {
            throw new IllegalArgumentException("Property 'key' is required");
        }
        this.secretKey = AesKeyGenerator.generateKey(this.key, this.keySize);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(this.chipperInstance);
            cipher.init(2, this.secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error decripting data", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(this.chipperInstance);
            cipher.init(1, this.secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error encripting data", e);
        }
    }
}

