/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataexport;

import java.io.OutputStream;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import si.nevensrok.common.dataexport.AbstractFileWriter;

public class XlsxFileWriter
extends AbstractFileWriter {
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    private int rownum = 0;
    private OutputStream outputStream;

    @Override
    public void init(OutputStream outputStream) throws Exception {
        this.outputStream = outputStream;
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet();
    }

    @Override
    public void close() throws Exception {
        this.workbook.write(this.outputStream);
    }

    @Override
    public void writeLine(String[] line) throws Exception {
        XSSFRow row = this.sheet.createRow(this.rownum++);
        for (int i = 0; i < line.length; ++i) {
            XSSFCell cell = row.createCell(i, 1);
            cell.setCellValue(line[i]);
        }
    }
}

