/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.memory;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.cache.AbstractCache;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;

public class MemoryCache
extends AbstractCache {
    private static final Logger log = LoggerFactory.getLogger(MemoryCache.class);
    private Map<Object, CachedValue> cache = new HashMap<Object, CachedValue>();
    private LinkedList<Object> keyList = new LinkedList();

    public MemoryCache(String name, CacheSettings cacheSettings) {
        super(name, cacheSettings);
    }

    @Override
    public synchronized CachedValue get(Object key) {
        CachedValue cachedValue = this.cache.get(key);
        if (cachedValue != null && !this.isCacheValid(cachedValue)) {
            cachedValue = null;
        }
        return cachedValue;
    }

    public synchronized void put(Object key, Object value) {
        this.putAndReturn(key, value, System.currentTimeMillis());
    }

    protected synchronized CachedValue putAndReturn(Object key, Object value, long createdAt) {
        this.cache.remove(key);
        this.keyList.remove(key);
        CachedValue cachedValue = new CachedValue(value, this.generateValidUntil(), createdAt);
        if (log.isTraceEnabled()) {
            log.trace("Adding to cache: {} -> {}", new Object[]{key, cachedValue});
        }
        this.cache.put(key, cachedValue);
        this.keyList.addFirst(key);
        if (this.getCacheSettings().getMaxElements() != null && this.cache.size() > this.getCacheSettings().getMaxElements()) {
            Object keyToRemove = this.keyList.removeLast();
            this.cache.remove(keyToRemove);
            log.trace("Removing key becuase of cache size: {}", keyToRemove);
        }
        return cachedValue;
    }

    @Override
    public synchronized CachedValue putIfAbsent(Object key, Object value) {
        return super.putIfAbsent(key, value);
    }

    public synchronized void evict(Object key) {
        this.cache.remove(key);
        this.keyList.remove(key);
    }

    public synchronized void clear() {
        this.cache.clear();
        this.keyList.clear();
    }
}

