/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.hazelcast;

import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import si.nevensrok.common.remoting.hazelcast.MethodExecutionCallable;
import si.nevensrok.common.remoting.hazelcast.MethodExecutionResult;
import si.nevensrok.common.remoting.hazelcast.ServiceExporter;
import si.nevensrok.common.remoting.hazelcast.ServiceRepository;

public class HazelcastServiceProxyFactoryBean
implements FactoryBean<Object>,
MethodInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HazelcastServiceProxyFactoryBean.class);
    private Random random = new Random();
    private ServiceRepository serviceRepository;
    private Class<?> serviceInterface;
    private String version;
    private boolean preferLocalBean = true;
    private long memberLookupTimeout = 10000L;
    private long methodCallTimeout = 0L;
    private Object serviceProxy;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public ServiceRepository getServiceRepository() {
        return this.serviceRepository;
    }

    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isPreferLocalBean() {
        return this.preferLocalBean;
    }

    public void setPreferLocalBean(boolean preferLocalBean) {
        this.preferLocalBean = preferLocalBean;
    }

    public long getMemberLookupTimeout() {
        return this.memberLookupTimeout;
    }

    public void setMemberLookupTimeout(long memberLookupTimeout) {
        this.memberLookupTimeout = memberLookupTimeout;
    }

    public long getMethodCallTimeout() {
        return this.methodCallTimeout;
    }

    public void setMethodCallTimeout(long methodCallTimeout) {
        this.methodCallTimeout = methodCallTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serviceRepository == null) {
            throw new IllegalArgumentException("Property 'serviceRepository' is required");
        }
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.version == null) {
            throw new IllegalArgumentException("Property 'version' is required");
        }
        this.serviceProxy = new ProxyFactory(this.serviceInterface, (Interceptor)this).getProxy(this.beanClassLoader);
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ServiceExporter serviceExporter;
        String methodName = invocation.getMethod().getName();
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        Object[] arguments = invocation.getArguments();
        if (this.preferLocalBean && (serviceExporter = this.serviceRepository.getServiceExporterFor(this.serviceInterface.getName(), this.version)) != null) {
            log.trace("Executing local service exporter");
            try {
                Object result = serviceExporter.getHazelcastInvokerServiceExporter().invoke(methodName, parameterTypes, arguments);
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        long memberLookupTimeLimit = System.currentTimeMillis() + this.memberLookupTimeout;
        List<Member> members = null;
        while (System.currentTimeMillis() < memberLookupTimeLimit && ((members = this.serviceRepository.getMembersFor(this.serviceInterface.getName(), this.version)) == null || members.isEmpty())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (members == null || members.isEmpty()) {
            throw new RuntimeException("Member lookup failed");
        }
        while (!members.isEmpty()) {
            Member member = members.remove(this.random.nextInt(members.size()));
            log.trace("Sending execution to member {}", (Object)member.getUuid());
            IExecutorService executorService = this.serviceRepository.getExecutorService();
            MethodExecutionCallable methodExecutionCallable = new MethodExecutionCallable(this.serviceInterface.getName(), this.version, methodName, parameterTypes, arguments);
            Future future = executorService.submitToMember((Callable)methodExecutionCallable, member);
            MethodExecutionResult methodExecutionResult = null;
            try {
                methodExecutionResult = this.methodCallTimeout > 0L ? (MethodExecutionResult)future.get(this.methodCallTimeout, TimeUnit.MILLISECONDS) : (MethodExecutionResult)future.get();
            }
            catch (Throwable e) {
                log.trace("Error calling method on member " + member.getUuid(), e);
                continue;
            }
            if (methodExecutionResult == null) {
                log.trace("Result is null");
                continue;
            }
            if (methodExecutionResult.getThrowable() != null) {
                throw methodExecutionResult.getThrowable();
            }
            return methodExecutionResult.getResult();
        }
        throw new RuntimeException("All calls to members failed");
    }

    public boolean isSingleton() {
        return true;
    }
}

