/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QREmailCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = 7849213953936964459L;
    private String email;

    public QREmailCode() {
    }

    public QREmailCode(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getCodeText() {
        return "mailto:" + this.email;
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.EMAIL;
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("mailto:")) {
                throw new QRCodeException("Not a email QR code!");
            }
            this.email = text.substring(7, text.length());
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QREmailCode [email=" + this.email + "]";
    }
}

