/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.mail;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.mail.Email;
import si.nevensrok.common.mail.MailSender;

public abstract class BackgroundMailSender
implements MailSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BackgroundMailSender.class);
    private boolean backgroundSenderActive = true;
    private Object emailSenderMonitor = new Object();
    private LinkedList<Email> emailList = new LinkedList();

    public void afterPropertiesSet() throws Exception {
        Thread thread = new Thread("Background email sender"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.info("Starting background email sender thread");
                while (BackgroundMailSender.this.backgroundSenderActive) {
                    Email email = null;
                    Object object = BackgroundMailSender.this.emailSenderMonitor;
                    synchronized (object) {
                        while (BackgroundMailSender.this.emailList.isEmpty() && BackgroundMailSender.this.backgroundSenderActive) {
                            try {
                                BackgroundMailSender.this.emailSenderMonitor.wait();
                            }
                            catch (Exception exception) {}
                        }
                        if (!BackgroundMailSender.this.emailList.isEmpty()) {
                            email = (Email)BackgroundMailSender.this.emailList.removeFirst();
                        }
                    }
                    if (email == null) continue;
                    try {
                        log.trace("Sending email {}", (Object)email);
                        BackgroundMailSender.this.sendEmail(email);
                    }
                    catch (Exception e) {
                        log.error("Error while sending email", (Throwable)e);
                    }
                }
                log.info("Stopping background email sender thread");
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.backgroundSenderActive = false;
        Object object = this.emailSenderMonitor;
        synchronized (object) {
            this.emailList.clear();
            this.emailSenderMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEmailInBackground(Email email) {
        if (this.backgroundSenderActive) {
            Object object = this.emailSenderMonitor;
            synchronized (object) {
                this.emailList.add(email);
                this.emailSenderMonitor.notifyAll();
            }
        }
    }
}

