/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionStateVersionMismatchException;
import com.hazelcast.internal.partition.impl.InternalMigrationListener;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.logging.Level;

abstract class BaseMigrationOperation
extends AbstractOperation
implements MigrationCycleOperation,
PartitionAwareOperation {
    protected MigrationInfo migrationInfo;
    protected boolean success;
    protected int partitionStateVersion;

    BaseMigrationOperation() {
    }

    BaseMigrationOperation(MigrationInfo migrationInfo, int partitionStateVersion) {
        this.migrationInfo = migrationInfo;
        this.partitionStateVersion = partitionStateVersion;
        this.setPartitionId(migrationInfo.getPartitionId());
    }

    @Override
    public final void beforeRun() throws Exception {
        try {
            this.onMigrationStart();
            this.verifyPartitionStateVersion();
            this.verifyMemberUuid();
            this.verifyClusterState();
        }
        catch (Exception e) {
            this.onMigrationComplete(false);
            throw e;
        }
    }

    private void verifyPartitionStateVersion() {
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        int localPartitionStateVersion = partitionService.getPartitionStateVersion();
        if (this.partitionStateVersion != localPartitionStateVersion) {
            if (this.getNodeEngine().getThisAddress().equals(this.migrationInfo.getMaster())) {
                return;
            }
            throw new PartitionStateVersionMismatchException(this.partitionStateVersion, localPartitionStateVersion);
        }
    }

    private void verifyMemberUuid() {
        Member localMember = this.getNodeEngine().getLocalMember();
        if (localMember.getAddress().equals(this.migrationInfo.getSource())) {
            if (!localMember.getUuid().equals(this.migrationInfo.getSourceUuid())) {
                throw new IllegalStateException("This member " + localMember + " is the migration source but has a different uuid! Migration: " + this.migrationInfo);
            }
        } else if (localMember.getAddress().equals(this.migrationInfo.getDestination()) && !localMember.getUuid().equals(this.migrationInfo.getDestinationUuid())) {
            throw new IllegalStateException("This member " + localMember + " is the migration destination but has a different uuid! Migration: " + this.migrationInfo);
        }
    }

    private void verifyClusterState() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        ClusterState clusterState = nodeEngine.getClusterService().getClusterState();
        if (clusterState != ClusterState.ACTIVE) {
            throw new IllegalStateException("Cluster state is not active! " + (Object)((Object)clusterState));
        }
        Node node = nodeEngine.getNode();
        if (!node.getNodeExtension().isStartCompleted()) {
            throw new IllegalStateException("Migration operation is received before startup is completed. Caller: " + this.getCallerAddress());
        }
    }

    void onMigrationStart() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalMigrationListener migrationListener = partitionService.getInternalMigrationListener();
        migrationListener.onMigrationStart(this.getMigrationParticipantType(), this.migrationInfo);
    }

    void onMigrationComplete() {
        this.onMigrationComplete(this.success);
    }

    void onMigrationComplete(boolean result) {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalMigrationListener migrationListener = partitionService.getInternalMigrationListener();
        migrationListener.onMigrationComplete(this.getMigrationParticipantType(), this.migrationInfo, result);
    }

    void executeBeforeMigrations() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionMigrationEvent event = this.getMigrationEvent();
        Throwable t = null;
        for (MigrationAwareService service : nodeEngine.getServices(MigrationAwareService.class)) {
            try {
                service.beforeMigration(event);
            }
            catch (Throwable e) {
                this.getLogger().warning("Error while executing beforeMigration()", e);
                t = e;
            }
        }
        if (t != null) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected abstract PartitionMigrationEvent getMigrationEvent();

    protected abstract InternalMigrationListener.MigrationParticipant getMigrationParticipantType();

    InternalPartition getPartition() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        return partitionService.getPartitionStateManager().getPartitionImpl(this.migrationInfo.getPartitionId());
    }

    public MigrationInfo getMigrationInfo() {
        return this.migrationInfo;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (!this.migrationInfo.isValid()) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof PartitionStateVersionMismatchException) {
            ILogger logger = this.getLogger();
            if (logger.isFineEnabled()) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            return;
        }
        super.logError(e);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.migrationInfo.writeData(out);
        out.writeInt(this.partitionStateVersion);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.migrationInfo = new MigrationInfo();
        this.migrationInfo.readData(in);
        this.partitionStateVersion = in.readInt();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", migration=").append(this.migrationInfo);
    }
}

