/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.impl.TcpIpJoiner;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.AddressUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class DefaultAddressPicker
implements AddressPicker {
    private static final int SOCKET_BACKLOG_LENGTH = 100;
    private static final int SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(1L);
    private final Node node;
    private final ILogger logger;
    private ServerSocketChannel serverSocketChannel;
    private Address publicAddress;
    private Address bindAddress;

    public DefaultAddressPicker(Node node) {
        this.node = node;
        this.logger = node.getLogger(DefaultAddressPicker.class);
    }

    @Override
    public void pickAddress() throws Exception {
        if (this.publicAddress != null || this.bindAddress != null) {
            return;
        }
        try {
            AddressDefinition publicAddressDef = this.getPublicAddressByPortSearch();
            if (publicAddressDef != null) {
                this.publicAddress = this.createAddress(publicAddressDef, publicAddressDef.port);
                this.logger.info("Using public address: " + this.publicAddress);
            } else {
                this.publicAddress = this.bindAddress;
                this.logger.finest("Using public address the same as the bind address: " + this.publicAddress);
            }
        }
        catch (Exception e) {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            this.logger.severe(e);
            throw e;
        }
    }

    private AddressDefinition getPublicAddressByPortSearch() throws IOException {
        NetworkConfig networkConfig = this.node.getConfig().getNetworkConfig();
        boolean bindAny = this.node.getProperties().getBoolean(GroupProperty.SOCKET_SERVER_BIND_ANY);
        Exception error = null;
        ServerSocket serverSocket = null;
        boolean reuseAddress = networkConfig.isReuseAddress();
        this.logger.finest("inet reuseAddress:" + reuseAddress);
        int portCount = networkConfig.getPortCount();
        int port = networkConfig.getPort();
        AddressDefinition bindAddressDef = this.pickAddress(networkConfig);
        for (int i = 0; i < portCount; ++i) {
            this.serverSocketChannel = ServerSocketChannel.open();
            serverSocket = this.serverSocketChannel.socket();
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(SOCKET_TIMEOUT_MILLIS);
            try {
                InetSocketAddress inetSocketAddress = bindAny ? new InetSocketAddress(port) : new InetSocketAddress(bindAddressDef.inetAddress, port);
                this.logger.finest("Trying to bind inet socket address:" + inetSocketAddress);
                serverSocket.bind(inetSocketAddress, 100);
                this.logger.finest("Bind successful to inet socket address:" + inetSocketAddress);
                break;
            }
            catch (Exception e) {
                serverSocket.close();
                this.serverSocketChannel.close();
                if (networkConfig.isPortAutoIncrement()) {
                    ++port;
                } else {
                    String msg = "Port [" + port + "] is already in use and auto-increment is disabled." + " Hazelcast cannot start.";
                    this.logger.severe(msg, e);
                    throw new HazelcastException(msg, error);
                }
                error = e;
                continue;
            }
        }
        if (serverSocket == null || !serverSocket.isBound()) {
            throw new HazelcastException("ServerSocket bind has failed. Hazelcast cannot start! config-port: " + networkConfig.getPort() + ", latest-port: " + port, error);
        }
        this.serverSocketChannel.configureBlocking(false);
        this.bindAddress = this.createAddress(bindAddressDef, port);
        this.logger.info("Picked " + this.bindAddress + ", using socket " + serverSocket + ", bind any local is " + bindAny);
        return this.getPublicAddress(this.node.getConfig(), port);
    }

    private Address createAddress(AddressDefinition addressDef, int port) throws UnknownHostException {
        if (addressDef.host == null) {
            return new Address(addressDef.inetAddress, port);
        }
        return new Address(addressDef.host, port);
    }

    private AddressDefinition pickAddress(NetworkConfig networkConfig) throws UnknownHostException, SocketException {
        AddressDefinition addressDef = this.getSystemConfiguredAddress(this.node.getConfig());
        if (addressDef == null) {
            addressDef = this.pickInterfaceAddress(networkConfig);
        }
        if (addressDef != null) {
            addressDef.inetAddress = AddressUtil.fixScopeIdAndGetInetAddress(addressDef.inetAddress);
        }
        if (addressDef == null) {
            addressDef = this.pickLoopbackAddress();
        }
        return addressDef;
    }

    private AddressDefinition pickInterfaceAddress(NetworkConfig networkConfig) throws UnknownHostException, SocketException {
        AddressDefinition addressDef;
        Collection<InterfaceDefinition> interfaces = this.getInterfaces(networkConfig);
        if (interfaces.contains(new InterfaceDefinition("127.0.0.1")) || interfaces.contains(new InterfaceDefinition("localhost"))) {
            return this.pickLoopbackAddress();
        }
        if (this.preferIPv4Stack()) {
            this.logger.info("Prefer IPv4 stack is true.");
        }
        if (interfaces.size() > 0 && (addressDef = this.pickMatchingAddress(interfaces)) != null) {
            return addressDef;
        }
        if (networkConfig.getInterfaces().isEnabled()) {
            String msg = "Hazelcast CANNOT start on this node. No matching network interface found.\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
            this.logger.severe(msg);
            throw new RuntimeException(msg);
        }
        if (networkConfig.getJoin().getTcpIpConfig().isEnabled()) {
            this.logger.warning("Could not find a matching address to start with! Picking one of non-loopback addresses.");
        }
        return this.pickMatchingAddress(null);
    }

    private Collection<InterfaceDefinition> getInterfaces(NetworkConfig networkConfig) throws UnknownHostException {
        Map<String, String> addressDomainMap;
        TcpIpConfig tcpIpConfig = networkConfig.getJoin().getTcpIpConfig();
        if (tcpIpConfig.isEnabled()) {
            addressDomainMap = new LinkedHashMap();
            Collection<String> possibleAddresses = TcpIpJoiner.getConfigurationMembers(this.node.config);
            for (String string : possibleAddresses) {
                String addressHolder = AddressUtil.getAddressHolder(string).getAddress();
                if (AddressUtil.isIpAddress(addressHolder)) {
                    if (addressDomainMap.containsKey(addressHolder)) continue;
                    addressDomainMap.put(addressHolder, null);
                    continue;
                }
                try {
                    Collection<String> addresses = this.resolveDomainNames(addressHolder);
                    for (String address : addresses) {
                        addressDomainMap.put(address, addressHolder);
                    }
                }
                catch (UnknownHostException e) {
                    this.logger.warning("Cannot resolve hostname: '" + addressHolder + "'");
                }
            }
        } else {
            addressDomainMap = Collections.emptyMap();
        }
        HashSet<InterfaceDefinition> interfaces = new HashSet<InterfaceDefinition>();
        if (networkConfig.getInterfaces().isEnabled()) {
            Collection<String> configInterfaces = networkConfig.getInterfaces().getInterfaces();
            for (String configInterface : configInterfaces) {
                if (AddressUtil.isIpAddress(configInterface)) {
                    String hostname = this.findHostnameMatchingInterface(addressDomainMap, configInterface);
                    interfaces.add(new InterfaceDefinition(hostname, configInterface));
                    continue;
                }
                this.logger.info("'" + configInterface + "' is not an IP address! Removing from interface list.");
            }
            this.logger.info("Interfaces is enabled, trying to pick one address matching to one of: " + interfaces);
        } else if (tcpIpConfig.isEnabled()) {
            for (Map.Entry entry : addressDomainMap.entrySet()) {
                interfaces.add(new InterfaceDefinition((String)entry.getValue(), (String)entry.getKey()));
            }
            this.logger.info("Interfaces is disabled, trying to pick one address from TCP-IP config addresses: " + interfaces);
        }
        return interfaces;
    }

    private String findHostnameMatchingInterface(Map<String, String> addressDomainMap, String configInterface) {
        String hostname = addressDomainMap.get(configInterface);
        if (hostname != null) {
            return hostname;
        }
        for (Map.Entry<String, String> entry : addressDomainMap.entrySet()) {
            String address = entry.getKey();
            if (!AddressUtil.matchInterface(address, configInterface)) continue;
            return entry.getValue();
        }
        return null;
    }

    private Collection<String> resolveDomainNames(String domainName) throws UnknownHostException {
        InetAddress[] inetAddresses = InetAddress.getAllByName(domainName);
        LinkedList<String> addresses = new LinkedList<String>();
        for (InetAddress inetAddress : inetAddresses) {
            addresses.add(inetAddress.getHostAddress());
        }
        this.logger.warning("You configured your member address as host name. Please be aware of that your dns can be spoofed. Make sure that your dns configurations are correct.");
        this.logger.info("Resolving domain name '" + domainName + "' to address(es): " + addresses);
        return addresses;
    }

    private AddressDefinition getSystemConfiguredAddress(Config config) throws UnknownHostException {
        String address = config.getProperty("hazelcast.local.localAddress");
        if (address != null) {
            if ("127.0.0.1".equals(address = address.trim()) || "localhost".equals(address)) {
                return this.pickLoopbackAddress();
            }
            this.logger.info("Picking address configured by property 'hazelcast.local.localAddress'");
            return new AddressDefinition(address, InetAddress.getByName(address));
        }
        return null;
    }

    private AddressDefinition getPublicAddress(Config config, int defaultPort) throws UnknownHostException {
        String address = config.getProperty("hazelcast.local.publicAddress");
        if (address == null) {
            address = config.getNetworkConfig().getPublicAddress();
        }
        if (address != null) {
            if ("127.0.0.1".equals(address = address.trim()) || "localhost".equals(address)) {
                return this.pickLoopbackAddress(defaultPort);
            }
            AddressUtil.AddressHolder holder = AddressUtil.getAddressHolder(address, defaultPort);
            return new AddressDefinition(holder.getAddress(), holder.getPort(), InetAddress.getByName(holder.getAddress()));
        }
        return null;
    }

    private AddressDefinition pickLoopbackAddress() throws UnknownHostException {
        return new AddressDefinition(InetAddress.getByName("127.0.0.1"));
    }

    private AddressDefinition pickLoopbackAddress(int defaultPort) throws UnknownHostException {
        InetAddress adddress = InetAddress.getByName("127.0.0.1");
        return new AddressDefinition(adddress.getHostAddress(), defaultPort, adddress);
    }

    private AddressDefinition pickMatchingAddress(Collection<InterfaceDefinition> interfaces) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean preferIPv4Stack = this.preferIPv4Stack();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> e = ni.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress inetAddress = e.nextElement();
                if (preferIPv4Stack && inetAddress instanceof Inet6Address) continue;
                if (interfaces != null && !interfaces.isEmpty()) {
                    AddressDefinition address = this.match(inetAddress, interfaces);
                    if (address == null) continue;
                    return address;
                }
                if (inetAddress.isLoopbackAddress()) continue;
                return new AddressDefinition(inetAddress);
            }
        }
        return null;
    }

    private AddressDefinition match(InetAddress address, Collection<InterfaceDefinition> interfaces) {
        for (InterfaceDefinition inf : interfaces) {
            if (!AddressUtil.matchInterface(address.getHostAddress(), inf.address)) continue;
            return new AddressDefinition(inf.host, address);
        }
        return null;
    }

    private boolean preferIPv4Stack() {
        boolean preferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack") || this.node.getProperties().getBoolean(GroupProperty.PREFER_IPv4_STACK);
        JoinConfig join = this.node.getConfig().getNetworkConfig().getJoin();
        AwsConfig awsConfig = join.getAwsConfig();
        boolean awsEnabled = awsConfig != null && awsConfig.isEnabled();
        return preferIPv4Stack || awsEnabled;
    }

    @Deprecated
    public Address getAddress() {
        return this.getBindAddress();
    }

    @Override
    public Address getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public Address getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    private static class AddressDefinition
    extends InterfaceDefinition {
        InetAddress inetAddress;
        int port;

        AddressDefinition(InetAddress inetAddress) {
            super(inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
        }

        AddressDefinition(String host, InetAddress inetAddress) {
            super(host, inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
        }

        AddressDefinition(String host, int port, InetAddress inetAddress) {
            super(host, inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
            this.port = port;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AddressDefinition that = (AddressDefinition)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.inetAddress != null ? !this.inetAddress.equals(that.inetAddress) : that.inetAddress != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.inetAddress != null ? this.inetAddress.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }
    }

    private static class InterfaceDefinition {
        String host;
        String address;

        InterfaceDefinition(String address) {
            this.host = null;
            this.address = address;
        }

        InterfaceDefinition(String host, String address) {
            this.host = host;
            this.address = address;
        }

        public String toString() {
            return this.host != null ? this.host + "/" + this.address : this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterfaceDefinition that = (InterfaceDefinition)o;
            if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            return result;
        }
    }
}

