/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = -9005467959458491702L;
    private NumberFormat secondsNumberFormat = new DecimalFormat("00");
    private JLabel categoryLabel = new JLabel();
    private JLabel timeLabel = new JLabel();
    private JPanel hosekomiPanel = new JPanel();
    private JLabel hosekomiLabel = new JLabel();
    private JLabel[] lastHosekomiLabels = new JLabel[4];
    private Color infoFgColor = Color.BLACK;
    private Color infoBgColor = Color.WHITE;
    private Color timeRunningColor = new Color(0xFFFF73);
    private Font categoryFont = new Font("Serif", 1, 24);
    private Font timeFont = new Font("Serif", 1, 60);
    private Font hosekomiFont = new Font("Serif", 1, 40);
    private Font lastHosekomisFont = new Font("Serif", 0, 16);
    private MatchData matchData;
    private TimeTracker timeTracker;

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public InfoPanel() {
        this.setLayout(new GridLayout(3, 1));
        this.add(this.categoryLabel);
        this.add(this.timeLabel);
        this.add(this.hosekomiPanel);
        this.timeLabel.setFont(this.timeFont);
        this.hosekomiLabel.setFont(this.hosekomiFont);
        this.hosekomiPanel.setLayout(new BorderLayout());
        this.hosekomiPanel.add((Component)this.hosekomiLabel, "Center");
        JPanel lastHosekomisPanel = new JPanel();
        lastHosekomisPanel.setBackground(this.infoBgColor);
        this.hosekomiPanel.add((Component)lastHosekomisPanel, "South");
        lastHosekomisPanel.setLayout(new GridLayout(1, this.lastHosekomiLabels.length));
        for (int i = 0; i < this.lastHosekomiLabels.length; ++i) {
            this.lastHosekomiLabels[i] = new JLabel();
            this.lastHosekomiLabels[i].setHorizontalAlignment(0);
            this.lastHosekomiLabels[i].setBackground(this.infoBgColor);
            this.lastHosekomiLabels[i].setForeground(this.infoFgColor);
            this.lastHosekomiLabels[i].setFont(this.lastHosekomisFont);
            lastHosekomisPanel.add(this.lastHosekomiLabels[i]);
        }
    }

    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoPanel.this.categoryLabel.setOpaque(true);
                InfoPanel.this.categoryLabel.setBackground(InfoPanel.this.infoBgColor);
                InfoPanel.this.categoryLabel.setForeground(InfoPanel.this.infoFgColor);
                InfoPanel.this.categoryLabel.setFont(InfoPanel.this.categoryFont);
                InfoPanel.this.categoryLabel.setHorizontalAlignment(0);
                InfoPanel.this.categoryLabel.setText(InfoPanel.this.matchData.getCategory());
                FontSizeUtil.refitFontSize(InfoPanel.this.categoryFont, InfoPanel.this.categoryLabel);
                InfoPanel.this.timeLabel.setOpaque(true);
                if (InfoPanel.this.timeTracker.isTimeRunning()) {
                    InfoPanel.this.timeLabel.setBackground(InfoPanel.this.timeRunningColor);
                } else {
                    InfoPanel.this.timeLabel.setBackground(InfoPanel.this.infoBgColor);
                }
                InfoPanel.this.timeLabel.setForeground(InfoPanel.this.infoFgColor);
                InfoPanel.this.timeLabel.setHorizontalAlignment(0);
                long time = InfoPanel.this.matchData.getTimeLeft() / 1000L;
                long minutes = time / 60L;
                long seconds = time % 60L;
                if (InfoPanel.this.matchData.getTableType() == TableType.FIGHT || InfoPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                    InfoPanel.this.timeLabel.setText(String.valueOf(minutes) + ":" + InfoPanel.this.secondsNumberFormat.format(seconds));
                } else {
                    InfoPanel.this.timeLabel.setText("");
                }
                FontSizeUtil.refitFontSize(InfoPanel.this.timeFont, InfoPanel.this.timeLabel);
                InfoPanel.this.hosekomiLabel.setOpaque(true);
                if (InfoPanel.this.timeTracker.isHosekomiRunning()) {
                    InfoPanel.this.hosekomiLabel.setBackground(InfoPanel.this.timeRunningColor);
                } else {
                    InfoPanel.this.hosekomiLabel.setBackground(InfoPanel.this.infoBgColor);
                }
                InfoPanel.this.hosekomiLabel.setForeground(InfoPanel.this.infoFgColor);
                InfoPanel.this.hosekomiLabel.setHorizontalAlignment(0);
                if (InfoPanel.this.matchData.getTableType() == TableType.FIGHT || InfoPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                    InfoPanel.this.hosekomiLabel.setText(InfoPanel.this.secondsNumberFormat.format(InfoPanel.this.matchData.getHosekomiTime() / 1000L));
                    for (int i = 0; i < InfoPanel.this.lastHosekomiLabels.length; ++i) {
                        InfoPanel.this.lastHosekomiLabels[i].setText(InfoPanel.this.secondsNumberFormat.format(InfoPanel.this.matchData.getLastHostkomis()[i] / 1000L));
                    }
                } else {
                    InfoPanel.this.hosekomiLabel.setText("");
                    for (int i = 0; i < InfoPanel.this.lastHosekomiLabels.length; ++i) {
                        InfoPanel.this.lastHosekomiLabels[i].setText("");
                    }
                }
                FontSizeUtil.refitFontSize(InfoPanel.this.hosekomiFont, InfoPanel.this.hosekomiLabel);
            }
        });
    }
}

