/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction;

import com.hazelcast.internal.eviction.EvictionConfiguration;
import com.hazelcast.internal.eviction.EvictionPolicyComparator;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.EvictionPolicyType;
import com.hazelcast.internal.eviction.impl.comparator.LFUEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.comparator.LRUEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.evaluator.DefaultEvictionPolicyEvaluator;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class EvictionPolicyEvaluatorProvider {
    private static final ConcurrentMap<EvictionPolicyType, EvictionPolicyEvaluator> EVICTION_POLICY_COMPARATOR_MAP = new ConcurrentHashMap<EvictionPolicyType, EvictionPolicyEvaluator>();

    private EvictionPolicyEvaluatorProvider() {
    }

    private static EvictionPolicyComparator createEvictionPolicyComparator(EvictionPolicyType evictionPolicyType) {
        switch (evictionPolicyType) {
            case LRU: {
                return new LRUEvictionPolicyComparator();
            }
            case LFU: {
                return new LFUEvictionPolicyComparator();
            }
        }
        throw new IllegalArgumentException("Unsupported eviction policy type: " + (Object)((Object)evictionPolicyType));
    }

    public static EvictionPolicyEvaluator getEvictionPolicyEvaluator(EvictionConfiguration evictionConfig, ClassLoader classLoader) {
        if (evictionConfig == null) {
            return null;
        }
        EvictionPolicyComparator evictionPolicyComparator = null;
        String evictionPolicyComparatorClassName = evictionConfig.getComparatorClassName();
        if (!StringUtil.isNullOrEmpty(evictionPolicyComparatorClassName)) {
            try {
                evictionPolicyComparator = (EvictionPolicyComparator)ClassLoaderUtil.newInstance(classLoader, evictionPolicyComparatorClassName);
            }
            catch (Exception e) {
                ExceptionUtil.rethrow(e);
            }
        } else {
            EvictionPolicyComparator comparator = evictionConfig.getComparator();
            if (comparator != null) {
                evictionPolicyComparator = comparator;
            } else {
                EvictionPolicyType evictionPolicyType = evictionConfig.getEvictionPolicyType();
                if (evictionPolicyType == null) {
                    return null;
                }
                evictionPolicyComparator = EvictionPolicyEvaluatorProvider.createEvictionPolicyComparator(evictionPolicyType);
            }
        }
        return new DefaultEvictionPolicyEvaluator(evictionPolicyComparator);
    }
}

